/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dashboards;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.dashboards.ExecuteMessageQueryRequest;
import com.databricks.sdk.service.dashboards.GenieCreateConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieGetConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieGetMessageQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetMessageQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieMessage;
import com.databricks.sdk.service.dashboards.GenieService;
import com.databricks.sdk.service.dashboards.GenieStartConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieStartConversationResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class GenieImpl
implements GenieService {
    private final ApiClient apiClient;

    public GenieImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public GenieMessage createMessage(GenieCreateConversationMessageRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages", request.getSpaceId(), request.getConversationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, GenieMessage.class, headers);
    }

    @Override
    public GenieGetMessageQueryResultResponse executeMessageQuery(ExecuteMessageQueryRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/execute-query", request.getSpaceId(), request.getConversationId(), request.getMessageId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.POST(path, null, GenieGetMessageQueryResultResponse.class, headers);
    }

    @Override
    public GenieMessage getMessage(GenieGetConversationMessageRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s", request.getSpaceId(), request.getConversationId(), request.getMessageId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GenieMessage.class, headers);
    }

    @Override
    public GenieGetMessageQueryResultResponse getMessageQueryResult(GenieGetMessageQueryResultRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/query-result", request.getSpaceId(), request.getConversationId(), request.getMessageId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GenieGetMessageQueryResultResponse.class, headers);
    }

    @Override
    public GenieStartConversationResponse startConversation(GenieStartConversationMessageRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/start-conversation", request.getSpaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, GenieStartConversationResponse.class, headers);
    }
}

