/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateCredentialRequest;
import com.databricks.sdk.service.catalog.CredentialInfo;
import com.databricks.sdk.service.catalog.CredentialsService;
import com.databricks.sdk.service.catalog.DeleteCredentialRequest;
import com.databricks.sdk.service.catalog.DeleteCredentialResponse;
import com.databricks.sdk.service.catalog.GenerateTemporaryServiceCredentialRequest;
import com.databricks.sdk.service.catalog.GetCredentialRequest;
import com.databricks.sdk.service.catalog.ListCredentialsRequest;
import com.databricks.sdk.service.catalog.ListCredentialsResponse;
import com.databricks.sdk.service.catalog.TemporaryCredentials;
import com.databricks.sdk.service.catalog.UpdateCredentialRequest;
import com.databricks.sdk.service.catalog.ValidateCredentialRequest;
import com.databricks.sdk.service.catalog.ValidateCredentialResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class CredentialsImpl
implements CredentialsService {
    private final ApiClient apiClient;

    public CredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CredentialInfo createCredential(CreateCredentialRequest request) {
        String path = "/api/2.1/unity-catalog/credentials";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CredentialInfo.class, headers);
    }

    @Override
    public void deleteCredential(DeleteCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/credentials/%s", request.getNameArg());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteCredentialResponse.class, headers);
    }

    @Override
    public TemporaryCredentials generateTemporaryServiceCredential(GenerateTemporaryServiceCredentialRequest request) {
        String path = "/api/2.1/unity-catalog/temporary-service-credentials";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, TemporaryCredentials.class, headers);
    }

    @Override
    public CredentialInfo getCredential(GetCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/credentials/%s", request.getNameArg());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, CredentialInfo.class, headers);
    }

    @Override
    public ListCredentialsResponse listCredentials(ListCredentialsRequest request) {
        String path = "/api/2.1/unity-catalog/credentials";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListCredentialsResponse.class, headers);
    }

    @Override
    public CredentialInfo updateCredential(UpdateCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/credentials/%s", request.getNameArg());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, CredentialInfo.class, headers);
    }

    @Override
    public ValidateCredentialResponse validateCredential(ValidateCredentialRequest request) {
        String path = "/api/2.1/unity-catalog/validate-credentials";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, ValidateCredentialResponse.class, headers);
    }
}

