/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dashboards;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.dashboards.CreateDashboardRequest;
import com.databricks.sdk.service.dashboards.CreateScheduleRequest;
import com.databricks.sdk.service.dashboards.CreateSubscriptionRequest;
import com.databricks.sdk.service.dashboards.Dashboard;
import com.databricks.sdk.service.dashboards.DeleteScheduleRequest;
import com.databricks.sdk.service.dashboards.DeleteScheduleResponse;
import com.databricks.sdk.service.dashboards.DeleteSubscriptionRequest;
import com.databricks.sdk.service.dashboards.DeleteSubscriptionResponse;
import com.databricks.sdk.service.dashboards.GetDashboardRequest;
import com.databricks.sdk.service.dashboards.GetPublishedDashboardRequest;
import com.databricks.sdk.service.dashboards.GetScheduleRequest;
import com.databricks.sdk.service.dashboards.GetSubscriptionRequest;
import com.databricks.sdk.service.dashboards.LakeviewService;
import com.databricks.sdk.service.dashboards.ListDashboardsRequest;
import com.databricks.sdk.service.dashboards.ListDashboardsResponse;
import com.databricks.sdk.service.dashboards.ListSchedulesRequest;
import com.databricks.sdk.service.dashboards.ListSchedulesResponse;
import com.databricks.sdk.service.dashboards.ListSubscriptionsRequest;
import com.databricks.sdk.service.dashboards.ListSubscriptionsResponse;
import com.databricks.sdk.service.dashboards.MigrateDashboardRequest;
import com.databricks.sdk.service.dashboards.PublishRequest;
import com.databricks.sdk.service.dashboards.PublishedDashboard;
import com.databricks.sdk.service.dashboards.Schedule;
import com.databricks.sdk.service.dashboards.Subscription;
import com.databricks.sdk.service.dashboards.TrashDashboardRequest;
import com.databricks.sdk.service.dashboards.TrashDashboardResponse;
import com.databricks.sdk.service.dashboards.UnpublishDashboardRequest;
import com.databricks.sdk.service.dashboards.UnpublishDashboardResponse;
import com.databricks.sdk.service.dashboards.UpdateDashboardRequest;
import com.databricks.sdk.service.dashboards.UpdateScheduleRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class LakeviewImpl
implements LakeviewService {
    private final ApiClient apiClient;

    public LakeviewImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Dashboard create(CreateDashboardRequest request) {
        String path = "/api/2.0/lakeview/dashboards";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request.getDashboard(), Dashboard.class, headers);
    }

    @Override
    public Schedule createSchedule(CreateScheduleRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request.getSchedule(), Schedule.class, headers);
    }

    @Override
    public Subscription createSubscription(CreateSubscriptionRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s/subscriptions", request.getDashboardId(), request.getScheduleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request.getSubscription(), Subscription.class, headers);
    }

    @Override
    public void deleteSchedule(DeleteScheduleRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s", request.getDashboardId(), request.getScheduleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteScheduleResponse.class, headers);
    }

    @Override
    public void deleteSubscription(DeleteSubscriptionRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s/subscriptions/%s", request.getDashboardId(), request.getScheduleId(), request.getSubscriptionId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteSubscriptionResponse.class, headers);
    }

    @Override
    public Dashboard get(GetDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Dashboard.class, headers);
    }

    @Override
    public PublishedDashboard getPublished(GetPublishedDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/published", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, PublishedDashboard.class, headers);
    }

    @Override
    public Schedule getSchedule(GetScheduleRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s", request.getDashboardId(), request.getScheduleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Schedule.class, headers);
    }

    @Override
    public Subscription getSubscription(GetSubscriptionRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s/subscriptions/%s", request.getDashboardId(), request.getScheduleId(), request.getSubscriptionId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Subscription.class, headers);
    }

    @Override
    public ListDashboardsResponse list(ListDashboardsRequest request) {
        String path = "/api/2.0/lakeview/dashboards";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListDashboardsResponse.class, headers);
    }

    @Override
    public ListSchedulesResponse listSchedules(ListSchedulesRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListSchedulesResponse.class, headers);
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s/subscriptions", request.getDashboardId(), request.getScheduleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListSubscriptionsResponse.class, headers);
    }

    @Override
    public Dashboard migrate(MigrateDashboardRequest request) {
        String path = "/api/2.0/lakeview/dashboards/migrate";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Dashboard.class, headers);
    }

    @Override
    public PublishedDashboard publish(PublishRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/published", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, PublishedDashboard.class, headers);
    }

    @Override
    public void trash(TrashDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, TrashDashboardResponse.class, headers);
    }

    @Override
    public void unpublish(UnpublishDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/published", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, UnpublishDashboardResponse.class, headers);
    }

    @Override
    public Dashboard update(UpdateDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request.getDashboard(), Dashboard.class, headers);
    }

    @Override
    public Schedule updateSchedule(UpdateScheduleRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/schedules/%s", request.getDashboardId(), request.getScheduleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request.getSchedule(), Schedule.class, headers);
    }
}

