/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.ConnectionInfo;
import com.databricks.sdk.service.catalog.ConnectionsService;
import com.databricks.sdk.service.catalog.CreateConnection;
import com.databricks.sdk.service.catalog.DeleteConnectionRequest;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.GetConnectionRequest;
import com.databricks.sdk.service.catalog.ListConnectionsRequest;
import com.databricks.sdk.service.catalog.ListConnectionsResponse;
import com.databricks.sdk.service.catalog.UpdateConnection;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class ConnectionsImpl
implements ConnectionsService {
    private final ApiClient apiClient;

    public ConnectionsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ConnectionInfo create(CreateConnection request) {
        String path = "/api/2.1/unity-catalog/connections";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, ConnectionInfo.class, headers);
    }

    @Override
    public void delete(DeleteConnectionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/connections/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public ConnectionInfo get(GetConnectionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/connections/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ConnectionInfo.class, headers);
    }

    @Override
    public ListConnectionsResponse list(ListConnectionsRequest request) {
        String path = "/api/2.1/unity-catalog/connections";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListConnectionsResponse.class, headers);
    }

    @Override
    public ConnectionInfo update(UpdateConnection request) {
        String path = String.format("/api/2.1/unity-catalog/connections/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, ConnectionInfo.class, headers);
    }
}

