/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegration;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationService;
import com.databricks.sdk.service.oauth2.DeleteCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.DeleteCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationsOutput;
import com.databricks.sdk.service.oauth2.ListCustomAppIntegrationsRequest;
import com.databricks.sdk.service.oauth2.UpdateCustomAppIntegration;
import com.databricks.sdk.service.oauth2.UpdateCustomAppIntegrationOutput;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class CustomAppIntegrationImpl
implements CustomAppIntegrationService {
    private final ApiClient apiClient;

    public CustomAppIntegrationImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateCustomAppIntegrationOutput create(CreateCustomAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateCustomAppIntegrationOutput.class, headers);
    }

    @Override
    public void delete(DeleteCustomAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteCustomAppIntegrationOutput.class, headers);
    }

    @Override
    public GetCustomAppIntegrationOutput get(GetCustomAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetCustomAppIntegrationOutput.class, headers);
    }

    @Override
    public GetCustomAppIntegrationsOutput list(ListCustomAppIntegrationsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetCustomAppIntegrationsOutput.class, headers);
    }

    @Override
    public void update(UpdateCustomAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, UpdateCustomAppIntegrationOutput.class, headers);
    }
}

