/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateExternalLocation;
import com.databricks.sdk.service.catalog.DeleteExternalLocationRequest;
import com.databricks.sdk.service.catalog.ExternalLocationInfo;
import com.databricks.sdk.service.catalog.ExternalLocationsImpl;
import com.databricks.sdk.service.catalog.ExternalLocationsService;
import com.databricks.sdk.service.catalog.GetExternalLocationRequest;
import com.databricks.sdk.service.catalog.ListExternalLocationsRequest;
import com.databricks.sdk.service.catalog.ListExternalLocationsResponse;
import com.databricks.sdk.service.catalog.UpdateExternalLocation;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ExternalLocationsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalLocationsAPI.class);
    private final ExternalLocationsService impl;

    public ExternalLocationsAPI(ApiClient apiClient) {
        this.impl = new ExternalLocationsImpl(apiClient);
    }

    public ExternalLocationsAPI(ExternalLocationsService mock) {
        this.impl = mock;
    }

    public ExternalLocationInfo create(String name, String url, String credentialName) {
        return this.create(new CreateExternalLocation().setName(name).setUrl(url).setCredentialName(credentialName));
    }

    public ExternalLocationInfo create(CreateExternalLocation request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteExternalLocationRequest().setName(name));
    }

    public void delete(DeleteExternalLocationRequest request) {
        this.impl.delete(request);
    }

    public ExternalLocationInfo get(String name) {
        return this.get(new GetExternalLocationRequest().setName(name));
    }

    public ExternalLocationInfo get(GetExternalLocationRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ExternalLocationInfo> list(ListExternalLocationsRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::list, ListExternalLocationsResponse::getExternalLocations, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ExternalLocationInfo update(String name) {
        return this.update(new UpdateExternalLocation().setName(name));
    }

    public ExternalLocationInfo update(UpdateExternalLocation request) {
        return this.impl.update(request);
    }

    public ExternalLocationsService impl() {
        return this.impl;
    }
}

