/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.FormRequest;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.IDToken;
import com.databricks.sdk.core.oauth.IDTokenSource;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.sdk.core.oauth.Token;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksOAuthTokenSource
extends RefreshableTokenSource {
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksOAuthTokenSource.class);
    private final String clientId;
    private final String host;
    private final String accountId;
    private final OpenIDConnectEndpoints endpoints;
    private final String audience;
    private final IDTokenSource idTokenSource;
    private final HttpClient httpClient;
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:jwt";
    private static final String SCOPE = "all-apis";
    private static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String SUBJECT_TOKEN_PARAM = "subject_token";
    private static final String SUBJECT_TOKEN_TYPE_PARAM = "subject_token_type";
    private static final String SCOPE_PARAM = "scope";
    private static final String CLIENT_ID_PARAM = "client_id";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private DatabricksOAuthTokenSource(Builder builder) {
        this.clientId = builder.clientId;
        this.host = builder.host;
        this.accountId = builder.accountId;
        this.endpoints = builder.endpoints;
        this.audience = builder.audience;
        this.idTokenSource = builder.idTokenSource;
        this.httpClient = builder.httpClient;
    }

    private static void validate(Object value, String fieldName) {
        if (value == null) {
            LOG.error("Required parameter '{}' is null", (Object)fieldName);
            throw new IllegalArgumentException(String.format("Required parameter '%s' cannot be null", fieldName));
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            LOG.error("Required parameter '{}' is empty", (Object)fieldName);
            throw new IllegalArgumentException(String.format("Required parameter '%s' cannot be empty", fieldName));
        }
    }

    @Override
    public Token refresh() {
        OAuthResponse response;
        Response rawResponse;
        DatabricksOAuthTokenSource.validate(this.clientId, "ClientID");
        DatabricksOAuthTokenSource.validate(this.host, "Host");
        DatabricksOAuthTokenSource.validate(this.endpoints, "Endpoints");
        DatabricksOAuthTokenSource.validate(this.idTokenSource, "IDTokenSource");
        DatabricksOAuthTokenSource.validate(this.httpClient, "HttpClient");
        String effectiveAudience = this.determineAudience();
        IDToken idToken = this.idTokenSource.getIDToken(effectiveAudience);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE_PARAM, GRANT_TYPE);
        params.put(SUBJECT_TOKEN_PARAM, idToken.getValue());
        params.put(SUBJECT_TOKEN_TYPE_PARAM, SUBJECT_TOKEN_TYPE);
        params.put(SCOPE_PARAM, SCOPE);
        params.put(CLIENT_ID_PARAM, this.clientId);
        try {
            rawResponse = this.httpClient.execute(new FormRequest(this.endpoints.getTokenEndpoint(), params));
        }
        catch (IOException e) {
            LOG.error("Failed to exchange ID token for access token at {}: {}", new Object[]{this.endpoints.getTokenEndpoint(), e.getMessage(), e});
            throw new DatabricksException(String.format("Failed to exchange ID token for access token at %s: %s", this.endpoints.getTokenEndpoint(), e.getMessage()), e);
        }
        try {
            response = (OAuthResponse)OBJECT_MAPPER.readValue(rawResponse.getBody(), OAuthResponse.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse OAuth response from token endpoint {}: {}", new Object[]{this.endpoints.getTokenEndpoint(), e.getMessage(), e});
            throw new DatabricksException(String.format("Failed to parse OAuth response from token endpoint %s: %s", this.endpoints.getTokenEndpoint(), e.getMessage()));
        }
        if (response.getErrorCode() != null) {
            LOG.error("Token exchange failed with error: {} - {}", (Object)response.getErrorCode(), (Object)response.getErrorSummary());
            throw new IllegalArgumentException(String.format("Token exchange failed with error: %s - %s", response.getErrorCode(), response.getErrorSummary()));
        }
        LocalDateTime expiry = LocalDateTime.now().plusSeconds(response.getExpiresIn());
        return new Token(response.getAccessToken(), response.getTokenType(), response.getRefreshToken(), expiry);
    }

    private String determineAudience() {
        if (!Strings.isNullOrEmpty((String)this.audience)) {
            return this.audience;
        }
        if (!Strings.isNullOrEmpty((String)this.accountId)) {
            return this.accountId;
        }
        return this.endpoints.getTokenEndpoint();
    }

    public static class Builder {
        private final String clientId;
        private final String host;
        private final OpenIDConnectEndpoints endpoints;
        private final IDTokenSource idTokenSource;
        private final HttpClient httpClient;
        private String accountId;
        private String audience;

        public Builder(String clientId, String host, OpenIDConnectEndpoints endpoints, IDTokenSource idTokenSource, HttpClient httpClient) {
            this.clientId = clientId;
            this.host = host;
            this.endpoints = endpoints;
            this.idTokenSource = idTokenSource;
            this.httpClient = httpClient;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public DatabricksOAuthTokenSource build() {
            return new DatabricksOAuthTokenSource(this);
        }
    }
}

