/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.oauth.TokenSource;
import java.util.HashMap;

public class TokenSourceCredentialsProvider
implements CredentialsProvider {
    private final TokenSource tokenSource;
    private final String authType;

    public TokenSourceCredentialsProvider(TokenSource tokenSource, String authType) {
        this.tokenSource = tokenSource;
        this.authType = authType;
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        try {
            this.tokenSource.getToken().getAccessToken();
            return () -> {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Bearer " + this.tokenSource.getToken().getAccessToken());
                return headers;
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String authType() {
        return this.authType;
    }
}

