/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.DisableRequest;
import com.databricks.sdk.service.catalog.DisableResponse;
import com.databricks.sdk.service.catalog.EnableRequest;
import com.databricks.sdk.service.catalog.EnableResponse;
import com.databricks.sdk.service.catalog.ListSystemSchemasRequest;
import com.databricks.sdk.service.catalog.ListSystemSchemasResponse;
import com.databricks.sdk.service.catalog.SystemSchemasService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class SystemSchemasImpl
implements SystemSchemasService {
    private final ApiClient apiClient;

    public SystemSchemasImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void disable(DisableRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s/systemschemas/%s", request.getMetastoreId(), request.getSchemaName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DisableResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void enable(EnableRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s/systemschemas/%s", request.getMetastoreId(), request.getSchemaName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, EnableResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListSystemSchemasResponse list(ListSystemSchemasRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s/systemschemas", request.getMetastoreId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListSystemSchemasResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

