/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegration;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationService;
import com.databricks.sdk.service.oauth2.DeleteCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.DeleteCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationsOutput;
import com.databricks.sdk.service.oauth2.ListCustomAppIntegrationsRequest;
import com.databricks.sdk.service.oauth2.UpdateCustomAppIntegration;
import com.databricks.sdk.service.oauth2.UpdateCustomAppIntegrationOutput;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class CustomAppIntegrationImpl
implements CustomAppIntegrationService {
    private final ApiClient apiClient;

    public CustomAppIntegrationImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateCustomAppIntegrationOutput create(CreateCustomAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateCustomAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteCustomAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteCustomAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetCustomAppIntegrationOutput get(GetCustomAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetCustomAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetCustomAppIntegrationsOutput list(ListCustomAppIntegrationsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetCustomAppIntegrationsOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateCustomAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateCustomAppIntegrationOutput.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

