/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settings.AccountNetworkPolicy;
import com.databricks.sdk.service.settings.CreateNetworkPolicyRequest;
import com.databricks.sdk.service.settings.DeleteNetworkPolicyRequest;
import com.databricks.sdk.service.settings.DeleteNetworkPolicyRpcResponse;
import com.databricks.sdk.service.settings.GetNetworkPolicyRequest;
import com.databricks.sdk.service.settings.ListNetworkPoliciesRequest;
import com.databricks.sdk.service.settings.ListNetworkPoliciesResponse;
import com.databricks.sdk.service.settings.NetworkPoliciesService;
import com.databricks.sdk.service.settings.UpdateNetworkPolicyRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class NetworkPoliciesImpl
implements NetworkPoliciesService {
    private final ApiClient apiClient;

    public NetworkPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountNetworkPolicy createNetworkPolicyRpc(CreateNetworkPolicyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-policies", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getNetworkPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountNetworkPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteNetworkPolicyRpc(DeleteNetworkPolicyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-policies/%s", this.apiClient.configuredAccountID(), request.getNetworkPolicyId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteNetworkPolicyRpcResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountNetworkPolicy getNetworkPolicyRpc(GetNetworkPolicyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-policies/%s", this.apiClient.configuredAccountID(), request.getNetworkPolicyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountNetworkPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListNetworkPoliciesResponse listNetworkPoliciesRpc(ListNetworkPoliciesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-policies", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListNetworkPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountNetworkPolicy updateNetworkPolicyRpc(UpdateNetworkPolicyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-policies/%s", this.apiClient.configuredAccountID(), request.getNetworkPolicyId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request.getNetworkPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountNetworkPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

