/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.FormRequest;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenEndpointClient {
    private static final Logger LOG = LoggerFactory.getLogger(TokenEndpointClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private TokenEndpointClient() {
    }

    public static OAuthResponse requestToken(HttpClient httpClient, String tokenEndpointUrl, Map<String, String> params) throws DatabricksException {
        OAuthResponse response;
        Response rawResponse;
        Objects.requireNonNull(httpClient, "HttpClient cannot be null");
        Objects.requireNonNull(params, "Request parameters map cannot be null");
        Objects.requireNonNull(tokenEndpointUrl, "Token endpoint URL cannot be null");
        if (tokenEndpointUrl.isEmpty()) {
            throw new IllegalArgumentException("Token endpoint URL cannot be empty");
        }
        try {
            LOG.debug("Requesting token from endpoint: {}", (Object)tokenEndpointUrl);
            rawResponse = httpClient.execute(new FormRequest(tokenEndpointUrl, params));
        }
        catch (IOException e) {
            LOG.error("Failed to request token from {}: {}", new Object[]{tokenEndpointUrl, e.getMessage(), e});
            throw new DatabricksException(String.format("Failed to request token from %s: %s", tokenEndpointUrl, e.getMessage()), e);
        }
        try {
            response = (OAuthResponse)OBJECT_MAPPER.readValue(rawResponse.getBody(), OAuthResponse.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse OAuth response from token endpoint {}: {}", new Object[]{tokenEndpointUrl, e.getMessage(), e});
            throw new DatabricksException(String.format("Failed to parse OAuth response from token endpoint %s: %s", tokenEndpointUrl, e.getMessage()), e);
        }
        if (response.getErrorCode() != null) {
            String errorSummary = response.getErrorSummary() != null ? response.getErrorSummary() : "No summary provided.";
            LOG.error("Token request to {} failed with error: {} - {}", new Object[]{tokenEndpointUrl, response.getErrorCode(), errorSummary});
            throw new DatabricksException(String.format("Token request failed with error: %s - %s", response.getErrorCode(), errorSummary));
        }
        LOG.debug("Successfully obtained token response from {}", (Object)tokenEndpointUrl);
        return response;
    }
}

