/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.oauth.IDToken;
import com.databricks.sdk.core.oauth.IDTokenSource;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenEndpointClient;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksOAuthTokenSource
extends RefreshableTokenSource {
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksOAuthTokenSource.class);
    private final String clientId;
    private final String host;
    private final String accountId;
    private final OpenIDConnectEndpoints endpoints;
    private final String audience;
    private final IDTokenSource idTokenSource;
    private final HttpClient httpClient;
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:jwt";
    private static final String SCOPE = "all-apis";
    private static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String SUBJECT_TOKEN_PARAM = "subject_token";
    private static final String SUBJECT_TOKEN_TYPE_PARAM = "subject_token_type";
    private static final String SCOPE_PARAM = "scope";
    private static final String CLIENT_ID_PARAM = "client_id";

    private DatabricksOAuthTokenSource(Builder builder) {
        this.clientId = builder.clientId;
        this.host = builder.host;
        this.accountId = builder.accountId;
        this.endpoints = builder.endpoints;
        this.audience = builder.audience;
        this.idTokenSource = builder.idTokenSource;
        this.httpClient = builder.httpClient;
    }

    @Override
    public Token refresh() {
        OAuthResponse response;
        Objects.requireNonNull(this.clientId, "ClientID cannot be null");
        Objects.requireNonNull(this.host, "Host cannot be null");
        Objects.requireNonNull(this.endpoints, "Endpoints cannot be null");
        Objects.requireNonNull(this.idTokenSource, "IDTokenSource cannot be null");
        Objects.requireNonNull(this.httpClient, "HttpClient cannot be null");
        if (this.clientId.isEmpty()) {
            throw new IllegalArgumentException("ClientID cannot be empty");
        }
        if (this.host.isEmpty()) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
        String effectiveAudience = this.determineAudience();
        IDToken idToken = this.idTokenSource.getIDToken(effectiveAudience);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE_PARAM, GRANT_TYPE);
        params.put(SUBJECT_TOKEN_PARAM, idToken.getValue());
        params.put(SUBJECT_TOKEN_TYPE_PARAM, SUBJECT_TOKEN_TYPE);
        params.put(SCOPE_PARAM, SCOPE);
        params.put(CLIENT_ID_PARAM, this.clientId);
        try {
            response = TokenEndpointClient.requestToken(this.httpClient, this.endpoints.getTokenEndpoint(), params);
        }
        catch (DatabricksException e) {
            LOG.error("OAuth token exchange failed for client ID '{}' at {}: {}", new Object[]{this.clientId, this.endpoints.getTokenEndpoint(), e.getMessage(), e});
            throw e;
        }
        Instant expiry = Instant.now().plusSeconds(response.getExpiresIn());
        return new Token(response.getAccessToken(), response.getTokenType(), response.getRefreshToken(), expiry);
    }

    private String determineAudience() {
        if (!Strings.isNullOrEmpty((String)this.audience)) {
            return this.audience;
        }
        if (!Strings.isNullOrEmpty((String)this.accountId)) {
            return this.accountId;
        }
        return this.endpoints.getTokenEndpoint();
    }

    public static class Builder {
        private final String clientId;
        private final String host;
        private final OpenIDConnectEndpoints endpoints;
        private final IDTokenSource idTokenSource;
        private final HttpClient httpClient;
        private String accountId;
        private String audience;

        public Builder(String clientId, String host, OpenIDConnectEndpoints endpoints, IDTokenSource idTokenSource, HttpClient httpClient) {
            this.clientId = clientId;
            this.host = host;
            this.endpoints = endpoints;
            this.idTokenSource = idTokenSource;
            this.httpClient = httpClient;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public DatabricksOAuthTokenSource build() {
            return new DatabricksOAuthTokenSource(this);
        }
    }
}

