/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.FormRequest;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.sdk.core.oauth.Token;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;

class OidcTokenSource
extends RefreshableTokenSource {
    private final HttpClient httpClient;
    private final String tokenUrl;
    private final ImmutableMap<String, String> params;

    public OidcTokenSource(HttpClient httpClient, String tokenUrl, String clientId, String resource, String clientAssertion, String clientAssertionType) {
        this.httpClient = httpClient;
        this.tokenUrl = tokenUrl;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        OidcTokenSource.putIfDefined((ImmutableMap.Builder<String, String>)builder, "grant_type", "client_credentials");
        OidcTokenSource.putIfDefined((ImmutableMap.Builder<String, String>)builder, "resource", resource);
        OidcTokenSource.putIfDefined((ImmutableMap.Builder<String, String>)builder, "client_id", clientId);
        OidcTokenSource.putIfDefined((ImmutableMap.Builder<String, String>)builder, "client_assertion_type", clientAssertionType);
        OidcTokenSource.putIfDefined((ImmutableMap.Builder<String, String>)builder, "client_assertion", clientAssertion);
        this.params = builder.build();
    }

    private static void putIfDefined(ImmutableMap.Builder<String, String> builder, String key, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            builder.put((Object)key, (Object)value);
        }
    }

    @Override
    protected Token refresh() {
        OAuthResponse resp;
        Response rawResp;
        try {
            rawResp = this.httpClient.execute(new FormRequest(this.tokenUrl, (Map<String, String>)this.params));
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request auth token: " + e.getMessage(), e);
        }
        try {
            resp = (OAuthResponse)new ObjectMapper().readValue(rawResp.getBody(), OAuthResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request auth token: corrupted token: " + e.getMessage());
        }
        if (resp.getErrorCode() != null) {
            throw new IllegalArgumentException(resp.getErrorCode() + ": " + resp.getErrorSummary());
        }
        Instant expiry = Instant.now().plusSeconds(resp.getExpiresIn());
        return new Token(resp.getAccessToken(), resp.getTokenType(), resp.getRefreshToken(), expiry);
    }
}

