/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.billing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.billing.GetLogDeliveryConfigurationResponse;
import com.databricks.sdk.service.billing.GetLogDeliveryRequest;
import com.databricks.sdk.service.billing.ListLogDeliveryRequest;
import com.databricks.sdk.service.billing.LogDeliveryService;
import com.databricks.sdk.service.billing.PatchStatusResponse;
import com.databricks.sdk.service.billing.UpdateLogDeliveryConfigurationStatusRequest;
import com.databricks.sdk.service.billing.WrappedCreateLogDeliveryConfiguration;
import com.databricks.sdk.service.billing.WrappedLogDeliveryConfiguration;
import com.databricks.sdk.service.billing.WrappedLogDeliveryConfigurations;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class LogDeliveryImpl
implements LogDeliveryService {
    private final ApiClient apiClient;

    public LogDeliveryImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public WrappedLogDeliveryConfiguration create(WrappedCreateLogDeliveryConfiguration request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WrappedLogDeliveryConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetLogDeliveryConfigurationResponse get(GetLogDeliveryRequest request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery/%s", this.apiClient.configuredAccountID(), request.getLogDeliveryConfigurationId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetLogDeliveryConfigurationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WrappedLogDeliveryConfigurations list(ListLogDeliveryRequest request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WrappedLogDeliveryConfigurations.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patchStatus(UpdateLogDeliveryConfigurationStatusRequest request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery/%s", this.apiClient.configuredAccountID(), request.getLogDeliveryConfigurationId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, PatchStatusResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

