/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.AssignResponse;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.CreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.DeleteMetastoreRequest;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.GetMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.databricks.sdk.service.catalog.ListMetastoresRequest;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.MetastoresService;
import com.databricks.sdk.service.catalog.UnassignRequest;
import com.databricks.sdk.service.catalog.UnassignResponse;
import com.databricks.sdk.service.catalog.UpdateAssignmentResponse;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.service.catalog.UpdateMetastoreAssignment;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class MetastoresImpl
implements MetastoresService {
    private final ApiClient apiClient;

    public MetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void assign(CreateMetastoreAssignment request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, AssignResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MetastoreInfo create(CreateMetastore request) {
        String path = "/api/2.1/unity-catalog/metastores";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, MetastoreInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MetastoreAssignment current() {
        String path = "/api/2.1/unity-catalog/current-metastore-assignment";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MetastoreAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteMetastoreRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MetastoreInfo get(GetMetastoreRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MetastoreInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListMetastoresResponse list(ListMetastoresRequest request) {
        String path = "/api/2.1/unity-catalog/metastores";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListMetastoresResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetMetastoreSummaryResponse summary() {
        String path = "/api/2.1/unity-catalog/metastore_summary";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetMetastoreSummaryResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void unassign(UnassignRequest request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, UnassignResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MetastoreInfo update(UpdateMetastore request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, MetastoreInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateAssignment(UpdateMetastoreAssignment request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateAssignmentResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

