/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.catalog.CreateOnlineTableRequest;
import com.databricks.sdk.service.catalog.DeleteOnlineTableRequest;
import com.databricks.sdk.service.catalog.GetOnlineTableRequest;
import com.databricks.sdk.service.catalog.OnlineTable;
import com.databricks.sdk.service.catalog.OnlineTablesImpl;
import com.databricks.sdk.service.catalog.OnlineTablesService;
import com.databricks.sdk.service.catalog.ProvisioningInfoState;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class OnlineTablesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineTablesAPI.class);
    private final OnlineTablesService impl;

    public OnlineTablesAPI(ApiClient apiClient) {
        this.impl = new OnlineTablesImpl(apiClient);
    }

    public OnlineTablesAPI(OnlineTablesService mock) {
        this.impl = mock;
    }

    public OnlineTable waitGetOnlineTableActive(String name) throws TimeoutException {
        return this.waitGetOnlineTableActive(name, Duration.ofMinutes(20L), null);
    }

    public OnlineTable waitGetOnlineTableActive(String name, Duration timeout, Consumer<OnlineTable> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ProvisioningInfoState> targetStates = Arrays.asList(ProvisioningInfoState.ACTIVE);
        List<ProvisioningInfoState> failureStates = Arrays.asList(ProvisioningInfoState.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            OnlineTable poll = this.get(new GetOnlineTableRequest().setName(name));
            ProvisioningInfoState status = poll.getUnityCatalogProvisioningState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach ACTIVE, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<OnlineTable, OnlineTable> create(OnlineTable table) {
        return this.create(new CreateOnlineTableRequest().setTable(table));
    }

    public Wait<OnlineTable, OnlineTable> create(CreateOnlineTableRequest request) {
        OnlineTable response = this.impl.create(request);
        return new Wait<OnlineTable, OnlineTable>((timeout, callback) -> this.waitGetOnlineTableActive(response.getName(), timeout, callback), response);
    }

    public void delete(String name) {
        this.delete(new DeleteOnlineTableRequest().setName(name));
    }

    public void delete(DeleteOnlineTableRequest request) {
        this.impl.delete(request);
    }

    public OnlineTable get(String name) {
        return this.get(new GetOnlineTableRequest().setName(name));
    }

    public OnlineTable get(GetOnlineTableRequest request) {
        return this.impl.get(request);
    }

    public OnlineTablesService impl() {
        return this.impl;
    }
}

