/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dashboards;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.dashboards.GenieCreateConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieExecuteMessageAttachmentQueryRequest;
import com.databricks.sdk.service.dashboards.GenieExecuteMessageQueryRequest;
import com.databricks.sdk.service.dashboards.GenieGenerateDownloadFullQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGenerateDownloadFullQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieGetConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieGetDownloadFullQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetDownloadFullQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieGetMessageAttachmentQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetMessageQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetMessageQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieGetQueryResultByAttachmentRequest;
import com.databricks.sdk.service.dashboards.GenieGetSpaceRequest;
import com.databricks.sdk.service.dashboards.GenieImpl;
import com.databricks.sdk.service.dashboards.GenieListSpacesRequest;
import com.databricks.sdk.service.dashboards.GenieListSpacesResponse;
import com.databricks.sdk.service.dashboards.GenieMessage;
import com.databricks.sdk.service.dashboards.GenieService;
import com.databricks.sdk.service.dashboards.GenieSpace;
import com.databricks.sdk.service.dashboards.GenieStartConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieStartConversationResponse;
import com.databricks.sdk.service.dashboards.MessageStatus;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class GenieAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GenieAPI.class);
    private final GenieService impl;

    public GenieAPI(ApiClient apiClient) {
        this.impl = new GenieImpl(apiClient);
    }

    public GenieAPI(GenieService mock) {
        this.impl = mock;
    }

    public GenieMessage waitGetMessageGenieCompleted(String conversationId, String messageId, String spaceId) throws TimeoutException {
        return this.waitGetMessageGenieCompleted(conversationId, messageId, spaceId, Duration.ofMinutes(20L), null);
    }

    public GenieMessage waitGetMessageGenieCompleted(String conversationId, String messageId, String spaceId, Duration timeout, Consumer<GenieMessage> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<MessageStatus> targetStates = Arrays.asList(MessageStatus.COMPLETED);
        List<MessageStatus> failureStates = Arrays.asList(MessageStatus.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            GenieMessage poll = this.getMessage(new GenieGetConversationMessageRequest().setConversationId(conversationId).setMessageId(messageId).setSpaceId(spaceId));
            MessageStatus status = poll.getStatus();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach COMPLETED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("conversationId=%s, messageId=%s, spaceId=%s", conversationId, messageId, spaceId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<GenieMessage, GenieMessage> createMessage(String spaceId, String conversationId, String content) {
        return this.createMessage(new GenieCreateConversationMessageRequest().setSpaceId(spaceId).setConversationId(conversationId).setContent(content));
    }

    public Wait<GenieMessage, GenieMessage> createMessage(GenieCreateConversationMessageRequest request) {
        GenieMessage response = this.impl.createMessage(request);
        return new Wait<GenieMessage, GenieMessage>((timeout, callback) -> this.waitGetMessageGenieCompleted(request.getConversationId(), response.getMessageId(), request.getSpaceId(), timeout, callback), response);
    }

    public GenieGetMessageQueryResultResponse executeMessageAttachmentQuery(String spaceId, String conversationId, String messageId, String attachmentId) {
        return this.executeMessageAttachmentQuery(new GenieExecuteMessageAttachmentQueryRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId));
    }

    public GenieGetMessageQueryResultResponse executeMessageAttachmentQuery(GenieExecuteMessageAttachmentQueryRequest request) {
        return this.impl.executeMessageAttachmentQuery(request);
    }

    public GenieGetMessageQueryResultResponse executeMessageQuery(String spaceId, String conversationId, String messageId) {
        return this.executeMessageQuery(new GenieExecuteMessageQueryRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId));
    }

    public GenieGetMessageQueryResultResponse executeMessageQuery(GenieExecuteMessageQueryRequest request) {
        return this.impl.executeMessageQuery(request);
    }

    public GenieGenerateDownloadFullQueryResultResponse generateDownloadFullQueryResult(String spaceId, String conversationId, String messageId, String attachmentId) {
        return this.generateDownloadFullQueryResult(new GenieGenerateDownloadFullQueryResultRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId));
    }

    public GenieGenerateDownloadFullQueryResultResponse generateDownloadFullQueryResult(GenieGenerateDownloadFullQueryResultRequest request) {
        return this.impl.generateDownloadFullQueryResult(request);
    }

    public GenieGetDownloadFullQueryResultResponse getDownloadFullQueryResult(String spaceId, String conversationId, String messageId, String attachmentId, String downloadId) {
        return this.getDownloadFullQueryResult(new GenieGetDownloadFullQueryResultRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId).setDownloadId(downloadId));
    }

    public GenieGetDownloadFullQueryResultResponse getDownloadFullQueryResult(GenieGetDownloadFullQueryResultRequest request) {
        return this.impl.getDownloadFullQueryResult(request);
    }

    public GenieMessage getMessage(String spaceId, String conversationId, String messageId) {
        return this.getMessage(new GenieGetConversationMessageRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId));
    }

    public GenieMessage getMessage(GenieGetConversationMessageRequest request) {
        return this.impl.getMessage(request);
    }

    public GenieGetMessageQueryResultResponse getMessageAttachmentQueryResult(String spaceId, String conversationId, String messageId, String attachmentId) {
        return this.getMessageAttachmentQueryResult(new GenieGetMessageAttachmentQueryResultRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId));
    }

    public GenieGetMessageQueryResultResponse getMessageAttachmentQueryResult(GenieGetMessageAttachmentQueryResultRequest request) {
        return this.impl.getMessageAttachmentQueryResult(request);
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResult(String spaceId, String conversationId, String messageId) {
        return this.getMessageQueryResult(new GenieGetMessageQueryResultRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId));
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResult(GenieGetMessageQueryResultRequest request) {
        return this.impl.getMessageQueryResult(request);
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResultByAttachment(String spaceId, String conversationId, String messageId, String attachmentId) {
        return this.getMessageQueryResultByAttachment(new GenieGetQueryResultByAttachmentRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId));
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResultByAttachment(GenieGetQueryResultByAttachmentRequest request) {
        return this.impl.getMessageQueryResultByAttachment(request);
    }

    public GenieSpace getSpace(String spaceId) {
        return this.getSpace(new GenieGetSpaceRequest().setSpaceId(spaceId));
    }

    public GenieSpace getSpace(GenieGetSpaceRequest request) {
        return this.impl.getSpace(request);
    }

    public GenieListSpacesResponse listSpaces(GenieListSpacesRequest request) {
        return this.impl.listSpaces(request);
    }

    public Wait<GenieMessage, GenieStartConversationResponse> startConversation(String spaceId, String content) {
        return this.startConversation(new GenieStartConversationMessageRequest().setSpaceId(spaceId).setContent(content));
    }

    public Wait<GenieMessage, GenieStartConversationResponse> startConversation(GenieStartConversationMessageRequest request) {
        GenieStartConversationResponse response = this.impl.startConversation(request);
        return new Wait<GenieMessage, GenieStartConversationResponse>((timeout, callback) -> this.waitGetMessageGenieCompleted(response.getConversationId(), response.getMessageId(), request.getSpaceId(), timeout, callback), response);
    }

    public GenieService impl() {
        return this.impl;
    }
}

