/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dashboards;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.dashboards.GenieCreateConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieExecuteMessageAttachmentQueryRequest;
import com.databricks.sdk.service.dashboards.GenieExecuteMessageQueryRequest;
import com.databricks.sdk.service.dashboards.GenieGenerateDownloadFullQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGenerateDownloadFullQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieGetConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieGetDownloadFullQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetDownloadFullQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieGetMessageAttachmentQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetMessageQueryResultRequest;
import com.databricks.sdk.service.dashboards.GenieGetMessageQueryResultResponse;
import com.databricks.sdk.service.dashboards.GenieGetQueryResultByAttachmentRequest;
import com.databricks.sdk.service.dashboards.GenieGetSpaceRequest;
import com.databricks.sdk.service.dashboards.GenieListSpacesRequest;
import com.databricks.sdk.service.dashboards.GenieListSpacesResponse;
import com.databricks.sdk.service.dashboards.GenieMessage;
import com.databricks.sdk.service.dashboards.GenieService;
import com.databricks.sdk.service.dashboards.GenieSpace;
import com.databricks.sdk.service.dashboards.GenieStartConversationMessageRequest;
import com.databricks.sdk.service.dashboards.GenieStartConversationResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class GenieImpl
implements GenieService {
    private final ApiClient apiClient;

    public GenieImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public GenieMessage createMessage(GenieCreateConversationMessageRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages", request.getSpaceId(), request.getConversationId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, GenieMessage.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGetMessageQueryResultResponse executeMessageAttachmentQuery(GenieExecuteMessageAttachmentQueryRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/attachments/%s/execute-query", request.getSpaceId(), request.getConversationId(), request.getMessageId(), request.getAttachmentId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGetMessageQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGetMessageQueryResultResponse executeMessageQuery(GenieExecuteMessageQueryRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/execute-query", request.getSpaceId(), request.getConversationId(), request.getMessageId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGetMessageQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGenerateDownloadFullQueryResultResponse generateDownloadFullQueryResult(GenieGenerateDownloadFullQueryResultRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/attachments/%s/downloads", request.getSpaceId(), request.getConversationId(), request.getMessageId(), request.getAttachmentId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGenerateDownloadFullQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGetDownloadFullQueryResultResponse getDownloadFullQueryResult(GenieGetDownloadFullQueryResultRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/attachments/%s/downloads/%s", request.getSpaceId(), request.getConversationId(), request.getMessageId(), request.getAttachmentId(), request.getDownloadId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGetDownloadFullQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieMessage getMessage(GenieGetConversationMessageRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s", request.getSpaceId(), request.getConversationId(), request.getMessageId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieMessage.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGetMessageQueryResultResponse getMessageAttachmentQueryResult(GenieGetMessageAttachmentQueryResultRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/attachments/%s/query-result", request.getSpaceId(), request.getConversationId(), request.getMessageId(), request.getAttachmentId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGetMessageQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGetMessageQueryResultResponse getMessageQueryResult(GenieGetMessageQueryResultRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/query-result", request.getSpaceId(), request.getConversationId(), request.getMessageId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGetMessageQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieGetMessageQueryResultResponse getMessageQueryResultByAttachment(GenieGetQueryResultByAttachmentRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/conversations/%s/messages/%s/query-result/%s", request.getSpaceId(), request.getConversationId(), request.getMessageId(), request.getAttachmentId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieGetMessageQueryResultResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieSpace getSpace(GenieGetSpaceRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s", request.getSpaceId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieSpace.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieListSpacesResponse listSpaces(GenieListSpacesRequest request) {
        String path = "/api/2.0/genie/spaces";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GenieListSpacesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GenieStartConversationResponse startConversation(GenieStartConversationMessageRequest request) {
        String path = String.format("/api/2.0/genie/spaces/%s/start-conversation", request.getSpaceId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, GenieStartConversationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

