/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.database;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.database.CreateDatabaseCatalogRequest;
import com.databricks.sdk.service.database.CreateDatabaseInstanceRequest;
import com.databricks.sdk.service.database.CreateDatabaseTableRequest;
import com.databricks.sdk.service.database.CreateSyncedDatabaseTableRequest;
import com.databricks.sdk.service.database.DatabaseCatalog;
import com.databricks.sdk.service.database.DatabaseCredential;
import com.databricks.sdk.service.database.DatabaseImpl;
import com.databricks.sdk.service.database.DatabaseInstance;
import com.databricks.sdk.service.database.DatabaseService;
import com.databricks.sdk.service.database.DatabaseTable;
import com.databricks.sdk.service.database.DeleteDatabaseCatalogRequest;
import com.databricks.sdk.service.database.DeleteDatabaseInstanceRequest;
import com.databricks.sdk.service.database.DeleteDatabaseTableRequest;
import com.databricks.sdk.service.database.DeleteSyncedDatabaseTableRequest;
import com.databricks.sdk.service.database.FindDatabaseInstanceByUidRequest;
import com.databricks.sdk.service.database.GenerateDatabaseCredentialRequest;
import com.databricks.sdk.service.database.GetDatabaseCatalogRequest;
import com.databricks.sdk.service.database.GetDatabaseInstanceRequest;
import com.databricks.sdk.service.database.GetDatabaseTableRequest;
import com.databricks.sdk.service.database.GetSyncedDatabaseTableRequest;
import com.databricks.sdk.service.database.ListDatabaseInstancesRequest;
import com.databricks.sdk.service.database.ListDatabaseInstancesResponse;
import com.databricks.sdk.service.database.SyncedDatabaseTable;
import com.databricks.sdk.service.database.UpdateDatabaseInstanceRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class DatabaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseAPI.class);
    private final DatabaseService impl;

    public DatabaseAPI(ApiClient apiClient) {
        this.impl = new DatabaseImpl(apiClient);
    }

    public DatabaseAPI(DatabaseService mock) {
        this.impl = mock;
    }

    public DatabaseCatalog createDatabaseCatalog(DatabaseCatalog catalog) {
        return this.createDatabaseCatalog(new CreateDatabaseCatalogRequest().setCatalog(catalog));
    }

    public DatabaseCatalog createDatabaseCatalog(CreateDatabaseCatalogRequest request) {
        return this.impl.createDatabaseCatalog(request);
    }

    public DatabaseInstance createDatabaseInstance(DatabaseInstance databaseInstance) {
        return this.createDatabaseInstance(new CreateDatabaseInstanceRequest().setDatabaseInstance(databaseInstance));
    }

    public DatabaseInstance createDatabaseInstance(CreateDatabaseInstanceRequest request) {
        return this.impl.createDatabaseInstance(request);
    }

    public DatabaseTable createDatabaseTable(DatabaseTable table) {
        return this.createDatabaseTable(new CreateDatabaseTableRequest().setTable(table));
    }

    public DatabaseTable createDatabaseTable(CreateDatabaseTableRequest request) {
        return this.impl.createDatabaseTable(request);
    }

    public SyncedDatabaseTable createSyncedDatabaseTable(SyncedDatabaseTable syncedTable) {
        return this.createSyncedDatabaseTable(new CreateSyncedDatabaseTableRequest().setSyncedTable(syncedTable));
    }

    public SyncedDatabaseTable createSyncedDatabaseTable(CreateSyncedDatabaseTableRequest request) {
        return this.impl.createSyncedDatabaseTable(request);
    }

    public void deleteDatabaseCatalog(String name) {
        this.deleteDatabaseCatalog(new DeleteDatabaseCatalogRequest().setName(name));
    }

    public void deleteDatabaseCatalog(DeleteDatabaseCatalogRequest request) {
        this.impl.deleteDatabaseCatalog(request);
    }

    public void deleteDatabaseInstance(String name) {
        this.deleteDatabaseInstance(new DeleteDatabaseInstanceRequest().setName(name));
    }

    public void deleteDatabaseInstance(DeleteDatabaseInstanceRequest request) {
        this.impl.deleteDatabaseInstance(request);
    }

    public void deleteDatabaseTable(String name) {
        this.deleteDatabaseTable(new DeleteDatabaseTableRequest().setName(name));
    }

    public void deleteDatabaseTable(DeleteDatabaseTableRequest request) {
        this.impl.deleteDatabaseTable(request);
    }

    public void deleteSyncedDatabaseTable(String name) {
        this.deleteSyncedDatabaseTable(new DeleteSyncedDatabaseTableRequest().setName(name));
    }

    public void deleteSyncedDatabaseTable(DeleteSyncedDatabaseTableRequest request) {
        this.impl.deleteSyncedDatabaseTable(request);
    }

    public DatabaseInstance findDatabaseInstanceByUid(FindDatabaseInstanceByUidRequest request) {
        return this.impl.findDatabaseInstanceByUid(request);
    }

    public DatabaseCredential generateDatabaseCredential(GenerateDatabaseCredentialRequest request) {
        return this.impl.generateDatabaseCredential(request);
    }

    public DatabaseCatalog getDatabaseCatalog(String name) {
        return this.getDatabaseCatalog(new GetDatabaseCatalogRequest().setName(name));
    }

    public DatabaseCatalog getDatabaseCatalog(GetDatabaseCatalogRequest request) {
        return this.impl.getDatabaseCatalog(request);
    }

    public DatabaseInstance getDatabaseInstance(String name) {
        return this.getDatabaseInstance(new GetDatabaseInstanceRequest().setName(name));
    }

    public DatabaseInstance getDatabaseInstance(GetDatabaseInstanceRequest request) {
        return this.impl.getDatabaseInstance(request);
    }

    public DatabaseTable getDatabaseTable(String name) {
        return this.getDatabaseTable(new GetDatabaseTableRequest().setName(name));
    }

    public DatabaseTable getDatabaseTable(GetDatabaseTableRequest request) {
        return this.impl.getDatabaseTable(request);
    }

    public SyncedDatabaseTable getSyncedDatabaseTable(String name) {
        return this.getSyncedDatabaseTable(new GetSyncedDatabaseTableRequest().setName(name));
    }

    public SyncedDatabaseTable getSyncedDatabaseTable(GetSyncedDatabaseTableRequest request) {
        return this.impl.getSyncedDatabaseTable(request);
    }

    public Iterable<DatabaseInstance> listDatabaseInstances(ListDatabaseInstancesRequest request) {
        return new Paginator(request, this.impl::listDatabaseInstances, ListDatabaseInstancesResponse::getDatabaseInstances, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public DatabaseInstance updateDatabaseInstance(String name, DatabaseInstance databaseInstance, String updateMask) {
        return this.updateDatabaseInstance(new UpdateDatabaseInstanceRequest().setName(name).setDatabaseInstance(databaseInstance).setUpdateMask(updateMask));
    }

    public DatabaseInstance updateDatabaseInstance(UpdateDatabaseInstanceRequest request) {
        return this.impl.updateDatabaseInstance(request);
    }

    public DatabaseService impl() {
        return this.impl;
    }
}

