/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.qualitymonitorv2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.qualitymonitorv2.CreateQualityMonitorRequest;
import com.databricks.sdk.service.qualitymonitorv2.DeleteQualityMonitorRequest;
import com.databricks.sdk.service.qualitymonitorv2.GetQualityMonitorRequest;
import com.databricks.sdk.service.qualitymonitorv2.ListQualityMonitorRequest;
import com.databricks.sdk.service.qualitymonitorv2.ListQualityMonitorResponse;
import com.databricks.sdk.service.qualitymonitorv2.QualityMonitor;
import com.databricks.sdk.service.qualitymonitorv2.QualityMonitorV2Impl;
import com.databricks.sdk.service.qualitymonitorv2.QualityMonitorV2Service;
import com.databricks.sdk.service.qualitymonitorv2.UpdateQualityMonitorRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class QualityMonitorV2API {
    private static final Logger LOG = LoggerFactory.getLogger(QualityMonitorV2API.class);
    private final QualityMonitorV2Service impl;

    public QualityMonitorV2API(ApiClient apiClient) {
        this.impl = new QualityMonitorV2Impl(apiClient);
    }

    public QualityMonitorV2API(QualityMonitorV2Service mock) {
        this.impl = mock;
    }

    public QualityMonitor createQualityMonitor(QualityMonitor qualityMonitor) {
        return this.createQualityMonitor(new CreateQualityMonitorRequest().setQualityMonitor(qualityMonitor));
    }

    public QualityMonitor createQualityMonitor(CreateQualityMonitorRequest request) {
        return this.impl.createQualityMonitor(request);
    }

    public void deleteQualityMonitor(String objectType, String objectId) {
        this.deleteQualityMonitor(new DeleteQualityMonitorRequest().setObjectType(objectType).setObjectId(objectId));
    }

    public void deleteQualityMonitor(DeleteQualityMonitorRequest request) {
        this.impl.deleteQualityMonitor(request);
    }

    public QualityMonitor getQualityMonitor(String objectType, String objectId) {
        return this.getQualityMonitor(new GetQualityMonitorRequest().setObjectType(objectType).setObjectId(objectId));
    }

    public QualityMonitor getQualityMonitor(GetQualityMonitorRequest request) {
        return this.impl.getQualityMonitor(request);
    }

    public Iterable<QualityMonitor> listQualityMonitor(ListQualityMonitorRequest request) {
        return new Paginator(request, this.impl::listQualityMonitor, ListQualityMonitorResponse::getQualityMonitors, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public QualityMonitor updateQualityMonitor(String objectType, String objectId, QualityMonitor qualityMonitor) {
        return this.updateQualityMonitor(new UpdateQualityMonitorRequest().setObjectType(objectType).setObjectId(objectId).setQualityMonitor(qualityMonitor));
    }

    public QualityMonitor updateQualityMonitor(UpdateQualityMonitorRequest request) {
        return this.impl.updateQualityMonitor(request);
    }

    public QualityMonitorV2Service impl() {
        return this.impl;
    }
}

