/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.CreateNetworkConnectivityConfigRequest;
import com.databricks.sdk.service.settings.CreateNetworkConnectivityConfiguration;
import com.databricks.sdk.service.settings.CreatePrivateEndpointRule;
import com.databricks.sdk.service.settings.CreatePrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.DeleteNetworkConnectivityConfigurationRequest;
import com.databricks.sdk.service.settings.DeletePrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.GetNetworkConnectivityConfigurationRequest;
import com.databricks.sdk.service.settings.GetPrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.ListNetworkConnectivityConfigurationsRequest;
import com.databricks.sdk.service.settings.ListNetworkConnectivityConfigurationsResponse;
import com.databricks.sdk.service.settings.ListPrivateEndpointRulesRequest;
import com.databricks.sdk.service.settings.ListPrivateEndpointRulesResponse;
import com.databricks.sdk.service.settings.NccPrivateEndpointRule;
import com.databricks.sdk.service.settings.NetworkConnectivityConfiguration;
import com.databricks.sdk.service.settings.NetworkConnectivityImpl;
import com.databricks.sdk.service.settings.NetworkConnectivityService;
import com.databricks.sdk.service.settings.UpdateNccPrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.UpdatePrivateEndpointRule;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class NetworkConnectivityAPI {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkConnectivityAPI.class);
    private final NetworkConnectivityService impl;

    public NetworkConnectivityAPI(ApiClient apiClient) {
        this.impl = new NetworkConnectivityImpl(apiClient);
    }

    public NetworkConnectivityAPI(NetworkConnectivityService mock) {
        this.impl = mock;
    }

    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfiguration networkConnectivityConfig) {
        return this.createNetworkConnectivityConfiguration(new CreateNetworkConnectivityConfigRequest().setNetworkConnectivityConfig(networkConnectivityConfig));
    }

    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfigRequest request) {
        return this.impl.createNetworkConnectivityConfiguration(request);
    }

    public NccPrivateEndpointRule createPrivateEndpointRule(String networkConnectivityConfigId, CreatePrivateEndpointRule privateEndpointRule) {
        return this.createPrivateEndpointRule(new CreatePrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRule(privateEndpointRule));
    }

    public NccPrivateEndpointRule createPrivateEndpointRule(CreatePrivateEndpointRuleRequest request) {
        return this.impl.createPrivateEndpointRule(request);
    }

    public void deleteNetworkConnectivityConfiguration(String networkConnectivityConfigId) {
        this.deleteNetworkConnectivityConfiguration(new DeleteNetworkConnectivityConfigurationRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId));
    }

    public void deleteNetworkConnectivityConfiguration(DeleteNetworkConnectivityConfigurationRequest request) {
        this.impl.deleteNetworkConnectivityConfiguration(request);
    }

    public NccPrivateEndpointRule deletePrivateEndpointRule(String networkConnectivityConfigId, String privateEndpointRuleId) {
        return this.deletePrivateEndpointRule(new DeletePrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRuleId(privateEndpointRuleId));
    }

    public NccPrivateEndpointRule deletePrivateEndpointRule(DeletePrivateEndpointRuleRequest request) {
        return this.impl.deletePrivateEndpointRule(request);
    }

    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(String networkConnectivityConfigId) {
        return this.getNetworkConnectivityConfiguration(new GetNetworkConnectivityConfigurationRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId));
    }

    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(GetNetworkConnectivityConfigurationRequest request) {
        return this.impl.getNetworkConnectivityConfiguration(request);
    }

    public NccPrivateEndpointRule getPrivateEndpointRule(String networkConnectivityConfigId, String privateEndpointRuleId) {
        return this.getPrivateEndpointRule(new GetPrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRuleId(privateEndpointRuleId));
    }

    public NccPrivateEndpointRule getPrivateEndpointRule(GetPrivateEndpointRuleRequest request) {
        return this.impl.getPrivateEndpointRule(request);
    }

    public Iterable<NetworkConnectivityConfiguration> listNetworkConnectivityConfigurations(ListNetworkConnectivityConfigurationsRequest request) {
        return new Paginator(request, this.impl::listNetworkConnectivityConfigurations, ListNetworkConnectivityConfigurationsResponse::getItems, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<NccPrivateEndpointRule> listPrivateEndpointRules(String networkConnectivityConfigId) {
        return this.listPrivateEndpointRules(new ListPrivateEndpointRulesRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId));
    }

    public Iterable<NccPrivateEndpointRule> listPrivateEndpointRules(ListPrivateEndpointRulesRequest request) {
        return new Paginator(request, this.impl::listPrivateEndpointRules, ListPrivateEndpointRulesResponse::getItems, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public NccPrivateEndpointRule updatePrivateEndpointRule(String networkConnectivityConfigId, String privateEndpointRuleId, UpdatePrivateEndpointRule privateEndpointRule, String updateMask) {
        return this.updatePrivateEndpointRule(new UpdateNccPrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRuleId(privateEndpointRuleId).setPrivateEndpointRule(privateEndpointRule).setUpdateMask(updateMask));
    }

    public NccPrivateEndpointRule updatePrivateEndpointRule(UpdateNccPrivateEndpointRuleRequest request) {
        return this.impl.updatePrivateEndpointRule(request);
    }

    public NetworkConnectivityService impl() {
        return this.impl;
    }
}

