/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateTableRequest;
import com.databricks.sdk.service.catalog.DeleteTableRequest;
import com.databricks.sdk.service.catalog.ExistsRequest;
import com.databricks.sdk.service.catalog.GetTableRequest;
import com.databricks.sdk.service.catalog.ListSummariesRequest;
import com.databricks.sdk.service.catalog.ListTableSummariesResponse;
import com.databricks.sdk.service.catalog.ListTablesRequest;
import com.databricks.sdk.service.catalog.ListTablesResponse;
import com.databricks.sdk.service.catalog.TableExistsResponse;
import com.databricks.sdk.service.catalog.TableInfo;
import com.databricks.sdk.service.catalog.TableSummary;
import com.databricks.sdk.service.catalog.TablesImpl;
import com.databricks.sdk.service.catalog.TablesService;
import com.databricks.sdk.service.catalog.UpdateTableRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class TablesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TablesAPI.class);
    private final TablesService impl;

    public TablesAPI(ApiClient apiClient) {
        this.impl = new TablesImpl(apiClient);
    }

    public TablesAPI(TablesService mock) {
        this.impl = mock;
    }

    public TableInfo create(CreateTableRequest request) {
        return this.impl.create(request);
    }

    public void delete(String fullName) {
        this.delete(new DeleteTableRequest().setFullName(fullName));
    }

    public void delete(DeleteTableRequest request) {
        this.impl.delete(request);
    }

    public TableExistsResponse exists(String fullName) {
        return this.exists(new ExistsRequest().setFullName(fullName));
    }

    public TableExistsResponse exists(ExistsRequest request) {
        return this.impl.exists(request);
    }

    public TableInfo get(String fullName) {
        return this.get(new GetTableRequest().setFullName(fullName));
    }

    public TableInfo get(GetTableRequest request) {
        return this.impl.get(request);
    }

    public Iterable<TableInfo> list(String catalogName, String schemaName) {
        return this.list(new ListTablesRequest().setCatalogName(catalogName).setSchemaName(schemaName));
    }

    public Iterable<TableInfo> list(ListTablesRequest request) {
        return new Paginator(request, this.impl::list, ListTablesResponse::getTables, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<TableSummary> listSummaries(String catalogName) {
        return this.listSummaries(new ListSummariesRequest().setCatalogName(catalogName));
    }

    public Iterable<TableSummary> listSummaries(ListSummariesRequest request) {
        return new Paginator(request, this.impl::listSummaries, ListTableSummariesResponse::getTables, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void update(UpdateTableRequest request) {
        this.impl.update(request);
    }

    public TablesService impl() {
        return this.impl;
    }
}

