/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.marketplace.CreateProviderRequest;
import com.databricks.sdk.service.marketplace.CreateProviderResponse;
import com.databricks.sdk.service.marketplace.DeleteProviderRequest;
import com.databricks.sdk.service.marketplace.GetProviderRequest;
import com.databricks.sdk.service.marketplace.GetProviderResponse;
import com.databricks.sdk.service.marketplace.ListProvidersRequest;
import com.databricks.sdk.service.marketplace.ListProvidersResponse;
import com.databricks.sdk.service.marketplace.ProviderProvidersService;
import com.databricks.sdk.service.marketplace.UpdateProviderRequest;
import com.databricks.sdk.service.marketplace.UpdateProviderResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProviderProvidersImpl
implements ProviderProvidersService {
    private final ApiClient apiClient;

    public ProviderProvidersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateProviderResponse create(CreateProviderRequest request) {
        String path = "/api/2.0/marketplace-provider/provider";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateProviderResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteProviderRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/providers/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetProviderResponse get(GetProviderRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/providers/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetProviderResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProvidersResponse list(ListProvidersRequest request) {
        String path = "/api/2.0/marketplace-provider/providers";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProvidersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateProviderResponse update(UpdateProviderRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/providers/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateProviderResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

