/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenEndpointClient;
import com.databricks.sdk.core.oauth.TokenSource;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointTokenSource
implements TokenSource {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointTokenSource.class);
    private static final String JWT_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String AUTHORIZATION_DETAILS_PARAM = "authorization_details";
    private static final String ASSERTION_PARAM = "assertion";
    private static final String TOKEN_ENDPOINT = "/oidc/v1/token";
    private final TokenSource cpTokenSource;
    private final String authDetails;
    private final HttpClient httpClient;
    private final String host;

    public EndpointTokenSource(TokenSource cpTokenSource, String authDetails, HttpClient httpClient, String host) {
        this.cpTokenSource = Objects.requireNonNull(cpTokenSource, "Control plane token source cannot be null");
        this.authDetails = Objects.requireNonNull(authDetails, "Authorization details cannot be null");
        this.httpClient = Objects.requireNonNull(httpClient, "HTTP client cannot be null");
        this.host = Objects.requireNonNull(host, "Host cannot be null");
        if (authDetails.isEmpty()) {
            throw new IllegalArgumentException("Authorization details cannot be empty");
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
    }

    @Override
    public Token getToken() {
        OAuthResponse oauthResponse;
        Token cpToken = this.cpTokenSource.getToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE_PARAM, JWT_GRANT_TYPE);
        params.put(AUTHORIZATION_DETAILS_PARAM, this.authDetails);
        params.put(ASSERTION_PARAM, cpToken.getAccessToken());
        try {
            oauthResponse = TokenEndpointClient.requestToken(this.httpClient, this.host + TOKEN_ENDPOINT, params);
        }
        catch (DatabricksException | IllegalArgumentException | NullPointerException e) {
            LOG.error("Failed to exchange control plane token for dataplane token at endpoint {}: {}", new Object[]{TOKEN_ENDPOINT, e.getMessage(), e});
            throw e;
        }
        Instant expiry = Instant.now().plusSeconds(oauthResponse.getExpiresIn());
        return new Token(oauthResponse.getAccessToken(), oauthResponse.getTokenType(), oauthResponse.getRefreshToken(), expiry);
    }
}

