/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.databricks.sdk.core.oauth.CachedTokenSource;
import com.databricks.sdk.core.oauth.ClientCredentials;
import com.databricks.sdk.core.oauth.GitHubOidcTokenSupplier;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;

public class GithubOidcCredentialsProvider
implements CredentialsProvider {
    @Override
    public String authType() {
        return "github-oidc";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) throws DatabricksException {
        String endpointUrl;
        GitHubOidcTokenSupplier idTokenProvider = new GitHubOidcTokenSupplier(config.getHttpClient(), config.getActionsIdTokenRequestUrl(), config.getActionsIdTokenRequestToken(), config.getTokenAudience());
        if (!idTokenProvider.enabled().booleanValue() || config.getHost() == null || config.getClientId() == null) {
            return null;
        }
        try {
            endpointUrl = config.getOidcEndpoints().getTokenEndpoint();
        }
        catch (IOException e) {
            throw new DatabricksException("Unable to fetch OIDC endpoint: " + e.getMessage(), e);
        }
        ClientCredentials clientCredentials = new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getClientId()).withTokenUrl(endpointUrl).withScopes(config.getScopes()).withAuthParameterPosition(AuthParameterPosition.HEADER).withEndpointParametersSupplier(() -> new ImmutableMap.Builder().put((Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:jwt").put((Object)"subject_token", (Object)idTokenProvider.getOidcToken()).put((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange").build()).build();
        CachedTokenSource cachedTokenSource = new CachedTokenSource.Builder(clientCredentials).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
        return () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + cachedTokenSource.getToken().getAccessToken());
            return headers;
        };
    }
}

