/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.apps;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.apps.AppsSettingsImpl;
import com.databricks.sdk.service.apps.AppsSettingsService;
import com.databricks.sdk.service.apps.CreateCustomTemplateRequest;
import com.databricks.sdk.service.apps.CustomTemplate;
import com.databricks.sdk.service.apps.DeleteCustomTemplateRequest;
import com.databricks.sdk.service.apps.GetCustomTemplateRequest;
import com.databricks.sdk.service.apps.ListCustomTemplatesRequest;
import com.databricks.sdk.service.apps.ListCustomTemplatesResponse;
import com.databricks.sdk.service.apps.UpdateCustomTemplateRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AppsSettingsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AppsSettingsAPI.class);
    private final AppsSettingsService impl;

    public AppsSettingsAPI(ApiClient apiClient) {
        this.impl = new AppsSettingsImpl(apiClient);
    }

    public AppsSettingsAPI(AppsSettingsService mock) {
        this.impl = mock;
    }

    public CustomTemplate createCustomTemplate(CreateCustomTemplateRequest request) {
        return this.impl.createCustomTemplate(request);
    }

    public CustomTemplate deleteCustomTemplate(String name) {
        return this.deleteCustomTemplate(new DeleteCustomTemplateRequest().setName(name));
    }

    public CustomTemplate deleteCustomTemplate(DeleteCustomTemplateRequest request) {
        return this.impl.deleteCustomTemplate(request);
    }

    public CustomTemplate getCustomTemplate(String name) {
        return this.getCustomTemplate(new GetCustomTemplateRequest().setName(name));
    }

    public CustomTemplate getCustomTemplate(GetCustomTemplateRequest request) {
        return this.impl.getCustomTemplate(request);
    }

    public Iterable<CustomTemplate> listCustomTemplates(ListCustomTemplatesRequest request) {
        return new Paginator(request, this.impl::listCustomTemplates, ListCustomTemplatesResponse::getTemplates, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CustomTemplate updateCustomTemplate(UpdateCustomTemplateRequest request) {
        return this.impl.updateCustomTemplate(request);
    }

    public AppsSettingsService impl() {
        return this.impl;
    }
}

