/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreatePolicyRequest;
import com.databricks.sdk.service.catalog.DeletePolicyRequest;
import com.databricks.sdk.service.catalog.DeletePolicyResponse;
import com.databricks.sdk.service.catalog.GetPolicyRequest;
import com.databricks.sdk.service.catalog.ListPoliciesRequest;
import com.databricks.sdk.service.catalog.ListPoliciesResponse;
import com.databricks.sdk.service.catalog.PoliciesImpl;
import com.databricks.sdk.service.catalog.PoliciesService;
import com.databricks.sdk.service.catalog.PolicyInfo;
import com.databricks.sdk.service.catalog.UpdatePolicyRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class PoliciesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(PoliciesAPI.class);
    private final PoliciesService impl;

    public PoliciesAPI(ApiClient apiClient) {
        this.impl = new PoliciesImpl(apiClient);
    }

    public PoliciesAPI(PoliciesService mock) {
        this.impl = mock;
    }

    public PolicyInfo createPolicy(CreatePolicyRequest request) {
        return this.impl.createPolicy(request);
    }

    public DeletePolicyResponse deletePolicy(String onSecurableType, String onSecurableFullname, String name) {
        return this.deletePolicy(new DeletePolicyRequest().setOnSecurableType(onSecurableType).setOnSecurableFullname(onSecurableFullname).setName(name));
    }

    public DeletePolicyResponse deletePolicy(DeletePolicyRequest request) {
        return this.impl.deletePolicy(request);
    }

    public PolicyInfo getPolicy(String onSecurableType, String onSecurableFullname, String name) {
        return this.getPolicy(new GetPolicyRequest().setOnSecurableType(onSecurableType).setOnSecurableFullname(onSecurableFullname).setName(name));
    }

    public PolicyInfo getPolicy(GetPolicyRequest request) {
        return this.impl.getPolicy(request);
    }

    public Iterable<PolicyInfo> listPolicies(String onSecurableType, String onSecurableFullname) {
        return this.listPolicies(new ListPoliciesRequest().setOnSecurableType(onSecurableType).setOnSecurableFullname(onSecurableFullname));
    }

    public Iterable<PolicyInfo> listPolicies(ListPoliciesRequest request) {
        return new Paginator(request, this.impl::listPolicies, ListPoliciesResponse::getPolicies, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public PolicyInfo updatePolicy(UpdatePolicyRequest request) {
        return this.impl.updatePolicy(request);
    }

    public PoliciesService impl() {
        return this.impl;
    }
}

