/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.database;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.database.CreateDatabaseCatalogRequest;
import com.databricks.sdk.service.database.CreateDatabaseInstanceRequest;
import com.databricks.sdk.service.database.CreateDatabaseInstanceRoleRequest;
import com.databricks.sdk.service.database.CreateDatabaseTableRequest;
import com.databricks.sdk.service.database.CreateSyncedDatabaseTableRequest;
import com.databricks.sdk.service.database.DatabaseCatalog;
import com.databricks.sdk.service.database.DatabaseCredential;
import com.databricks.sdk.service.database.DatabaseImpl;
import com.databricks.sdk.service.database.DatabaseInstance;
import com.databricks.sdk.service.database.DatabaseInstanceRole;
import com.databricks.sdk.service.database.DatabaseInstanceState;
import com.databricks.sdk.service.database.DatabaseService;
import com.databricks.sdk.service.database.DatabaseTable;
import com.databricks.sdk.service.database.DeleteDatabaseCatalogRequest;
import com.databricks.sdk.service.database.DeleteDatabaseInstanceRequest;
import com.databricks.sdk.service.database.DeleteDatabaseInstanceRoleRequest;
import com.databricks.sdk.service.database.DeleteDatabaseTableRequest;
import com.databricks.sdk.service.database.DeleteSyncedDatabaseTableRequest;
import com.databricks.sdk.service.database.FindDatabaseInstanceByUidRequest;
import com.databricks.sdk.service.database.GenerateDatabaseCredentialRequest;
import com.databricks.sdk.service.database.GetDatabaseCatalogRequest;
import com.databricks.sdk.service.database.GetDatabaseInstanceRequest;
import com.databricks.sdk.service.database.GetDatabaseInstanceRoleRequest;
import com.databricks.sdk.service.database.GetDatabaseTableRequest;
import com.databricks.sdk.service.database.GetSyncedDatabaseTableRequest;
import com.databricks.sdk.service.database.ListDatabaseCatalogsRequest;
import com.databricks.sdk.service.database.ListDatabaseCatalogsResponse;
import com.databricks.sdk.service.database.ListDatabaseInstanceRolesRequest;
import com.databricks.sdk.service.database.ListDatabaseInstanceRolesResponse;
import com.databricks.sdk.service.database.ListDatabaseInstancesRequest;
import com.databricks.sdk.service.database.ListDatabaseInstancesResponse;
import com.databricks.sdk.service.database.ListSyncedDatabaseTablesRequest;
import com.databricks.sdk.service.database.ListSyncedDatabaseTablesResponse;
import com.databricks.sdk.service.database.SyncedDatabaseTable;
import com.databricks.sdk.service.database.UpdateDatabaseCatalogRequest;
import com.databricks.sdk.service.database.UpdateDatabaseInstanceRequest;
import com.databricks.sdk.service.database.UpdateSyncedDatabaseTableRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class DatabaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseAPI.class);
    private final DatabaseService impl;

    public DatabaseAPI(ApiClient apiClient) {
        this.impl = new DatabaseImpl(apiClient);
    }

    public DatabaseAPI(DatabaseService mock) {
        this.impl = mock;
    }

    public DatabaseInstance waitGetDatabaseInstanceDatabaseAvailable(String name) throws TimeoutException {
        return this.waitGetDatabaseInstanceDatabaseAvailable(name, Duration.ofMinutes(20L), null);
    }

    public DatabaseInstance waitGetDatabaseInstanceDatabaseAvailable(String name, Duration timeout, Consumer<DatabaseInstance> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<DatabaseInstanceState> targetStates = Arrays.asList(DatabaseInstanceState.AVAILABLE);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            DatabaseInstance poll = this.getDatabaseInstance(new GetDatabaseInstanceRequest().setName(name));
            DatabaseInstanceState status = poll.getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public DatabaseCatalog createDatabaseCatalog(CreateDatabaseCatalogRequest request) {
        return this.impl.createDatabaseCatalog(request);
    }

    public Wait<DatabaseInstance, DatabaseInstance> createDatabaseInstance(CreateDatabaseInstanceRequest request) {
        DatabaseInstance response = this.impl.createDatabaseInstance(request);
        return new Wait<DatabaseInstance, DatabaseInstance>((timeout, callback) -> this.waitGetDatabaseInstanceDatabaseAvailable(response.getName(), timeout, callback), response);
    }

    public DatabaseInstanceRole createDatabaseInstanceRole(CreateDatabaseInstanceRoleRequest request) {
        return this.impl.createDatabaseInstanceRole(request);
    }

    public DatabaseTable createDatabaseTable(CreateDatabaseTableRequest request) {
        return this.impl.createDatabaseTable(request);
    }

    public SyncedDatabaseTable createSyncedDatabaseTable(CreateSyncedDatabaseTableRequest request) {
        return this.impl.createSyncedDatabaseTable(request);
    }

    public void deleteDatabaseCatalog(String name) {
        this.deleteDatabaseCatalog(new DeleteDatabaseCatalogRequest().setName(name));
    }

    public void deleteDatabaseCatalog(DeleteDatabaseCatalogRequest request) {
        this.impl.deleteDatabaseCatalog(request);
    }

    public void deleteDatabaseInstance(String name) {
        this.deleteDatabaseInstance(new DeleteDatabaseInstanceRequest().setName(name));
    }

    public void deleteDatabaseInstance(DeleteDatabaseInstanceRequest request) {
        this.impl.deleteDatabaseInstance(request);
    }

    public void deleteDatabaseInstanceRole(String instanceName, String name) {
        this.deleteDatabaseInstanceRole(new DeleteDatabaseInstanceRoleRequest().setInstanceName(instanceName).setName(name));
    }

    public void deleteDatabaseInstanceRole(DeleteDatabaseInstanceRoleRequest request) {
        this.impl.deleteDatabaseInstanceRole(request);
    }

    public void deleteDatabaseTable(String name) {
        this.deleteDatabaseTable(new DeleteDatabaseTableRequest().setName(name));
    }

    public void deleteDatabaseTable(DeleteDatabaseTableRequest request) {
        this.impl.deleteDatabaseTable(request);
    }

    public void deleteSyncedDatabaseTable(String name) {
        this.deleteSyncedDatabaseTable(new DeleteSyncedDatabaseTableRequest().setName(name));
    }

    public void deleteSyncedDatabaseTable(DeleteSyncedDatabaseTableRequest request) {
        this.impl.deleteSyncedDatabaseTable(request);
    }

    public DatabaseInstance findDatabaseInstanceByUid(FindDatabaseInstanceByUidRequest request) {
        return this.impl.findDatabaseInstanceByUid(request);
    }

    public DatabaseCredential generateDatabaseCredential(GenerateDatabaseCredentialRequest request) {
        return this.impl.generateDatabaseCredential(request);
    }

    public DatabaseCatalog getDatabaseCatalog(String name) {
        return this.getDatabaseCatalog(new GetDatabaseCatalogRequest().setName(name));
    }

    public DatabaseCatalog getDatabaseCatalog(GetDatabaseCatalogRequest request) {
        return this.impl.getDatabaseCatalog(request);
    }

    public DatabaseInstance getDatabaseInstance(String name) {
        return this.getDatabaseInstance(new GetDatabaseInstanceRequest().setName(name));
    }

    public DatabaseInstance getDatabaseInstance(GetDatabaseInstanceRequest request) {
        return this.impl.getDatabaseInstance(request);
    }

    public DatabaseInstanceRole getDatabaseInstanceRole(String instanceName, String name) {
        return this.getDatabaseInstanceRole(new GetDatabaseInstanceRoleRequest().setInstanceName(instanceName).setName(name));
    }

    public DatabaseInstanceRole getDatabaseInstanceRole(GetDatabaseInstanceRoleRequest request) {
        return this.impl.getDatabaseInstanceRole(request);
    }

    public DatabaseTable getDatabaseTable(String name) {
        return this.getDatabaseTable(new GetDatabaseTableRequest().setName(name));
    }

    public DatabaseTable getDatabaseTable(GetDatabaseTableRequest request) {
        return this.impl.getDatabaseTable(request);
    }

    public SyncedDatabaseTable getSyncedDatabaseTable(String name) {
        return this.getSyncedDatabaseTable(new GetSyncedDatabaseTableRequest().setName(name));
    }

    public SyncedDatabaseTable getSyncedDatabaseTable(GetSyncedDatabaseTableRequest request) {
        return this.impl.getSyncedDatabaseTable(request);
    }

    public Iterable<DatabaseCatalog> listDatabaseCatalogs(String instanceName) {
        return this.listDatabaseCatalogs(new ListDatabaseCatalogsRequest().setInstanceName(instanceName));
    }

    public Iterable<DatabaseCatalog> listDatabaseCatalogs(ListDatabaseCatalogsRequest request) {
        return new Paginator(request, this.impl::listDatabaseCatalogs, ListDatabaseCatalogsResponse::getDatabaseCatalogs, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<DatabaseInstanceRole> listDatabaseInstanceRoles(String instanceName) {
        return this.listDatabaseInstanceRoles(new ListDatabaseInstanceRolesRequest().setInstanceName(instanceName));
    }

    public Iterable<DatabaseInstanceRole> listDatabaseInstanceRoles(ListDatabaseInstanceRolesRequest request) {
        return new Paginator(request, this.impl::listDatabaseInstanceRoles, ListDatabaseInstanceRolesResponse::getDatabaseInstanceRoles, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<DatabaseInstance> listDatabaseInstances(ListDatabaseInstancesRequest request) {
        return new Paginator(request, this.impl::listDatabaseInstances, ListDatabaseInstancesResponse::getDatabaseInstances, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<SyncedDatabaseTable> listSyncedDatabaseTables(String instanceName) {
        return this.listSyncedDatabaseTables(new ListSyncedDatabaseTablesRequest().setInstanceName(instanceName));
    }

    public Iterable<SyncedDatabaseTable> listSyncedDatabaseTables(ListSyncedDatabaseTablesRequest request) {
        return new Paginator(request, this.impl::listSyncedDatabaseTables, ListSyncedDatabaseTablesResponse::getSyncedTables, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public DatabaseCatalog updateDatabaseCatalog(UpdateDatabaseCatalogRequest request) {
        return this.impl.updateDatabaseCatalog(request);
    }

    public DatabaseInstance updateDatabaseInstance(UpdateDatabaseInstanceRequest request) {
        return this.impl.updateDatabaseInstance(request);
    }

    public SyncedDatabaseTable updateSyncedDatabaseTable(UpdateSyncedDatabaseTableRequest request) {
        return this.impl.updateSyncedDatabaseTable(request);
    }

    public DatabaseService impl() {
        return this.impl;
    }
}

