/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.AccountGroup;
import com.databricks.sdk.service.iam.AccountGroupsV2Impl;
import com.databricks.sdk.service.iam.AccountGroupsV2Service;
import com.databricks.sdk.service.iam.CreateAccountGroupRequest;
import com.databricks.sdk.service.iam.DeleteAccountGroupRequest;
import com.databricks.sdk.service.iam.GetAccountGroupRequest;
import com.databricks.sdk.service.iam.ListAccountGroupsRequest;
import com.databricks.sdk.service.iam.ListAccountGroupsResponse;
import com.databricks.sdk.service.iam.PatchAccountGroupRequest;
import com.databricks.sdk.service.iam.UpdateAccountGroupRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountGroupsV2API {
    private static final Logger LOG = LoggerFactory.getLogger(AccountGroupsV2API.class);
    private final AccountGroupsV2Service impl;

    public AccountGroupsV2API(ApiClient apiClient) {
        this.impl = new AccountGroupsV2Impl(apiClient);
    }

    public AccountGroupsV2API(AccountGroupsV2Service mock) {
        this.impl = mock;
    }

    public AccountGroup create(CreateAccountGroupRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteAccountGroupRequest().setId(id));
    }

    public void delete(DeleteAccountGroupRequest request) {
        this.impl.delete(request);
    }

    public AccountGroup get(String id) {
        return this.get(new GetAccountGroupRequest().setId(id));
    }

    public AccountGroup get(GetAccountGroupRequest request) {
        return this.impl.get(request);
    }

    public Iterable<AccountGroup> list(ListAccountGroupsRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator(request, this.impl::list, ListAccountGroupsResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        });
    }

    public void patch(PatchAccountGroupRequest request) {
        this.impl.patch(request);
    }

    public void update(UpdateAccountGroupRequest request) {
        this.impl.update(request);
    }

    public AccountGroupsV2Service impl() {
        return this.impl;
    }
}

