/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.iam.AccountServicePrincipal;
import com.databricks.sdk.service.iam.AccountServicePrincipalsV2Service;
import com.databricks.sdk.service.iam.CreateAccountServicePrincipalRequest;
import com.databricks.sdk.service.iam.DeleteAccountServicePrincipalRequest;
import com.databricks.sdk.service.iam.GetAccountServicePrincipalRequest;
import com.databricks.sdk.service.iam.ListAccountServicePrincipalsRequest;
import com.databricks.sdk.service.iam.ListAccountServicePrincipalsResponse;
import com.databricks.sdk.service.iam.PatchAccountServicePrincipalRequest;
import com.databricks.sdk.service.iam.UpdateAccountServicePrincipalRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountServicePrincipalsV2Impl
implements AccountServicePrincipalsV2Service {
    private final ApiClient apiClient;

    public AccountServicePrincipalsV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountServicePrincipal create(CreateAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountServicePrincipal.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountServicePrincipal get(GetAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountServicePrincipal.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAccountServicePrincipalsResponse list(ListAccountServicePrincipalsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAccountServicePrincipalsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PatchAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

