/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iamv2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.iamv2.AccountIamV2Service;
import com.databricks.sdk.service.iamv2.GetWorkspaceAccessDetailRequest;
import com.databricks.sdk.service.iamv2.ResolveGroupRequest;
import com.databricks.sdk.service.iamv2.ResolveGroupResponse;
import com.databricks.sdk.service.iamv2.ResolveServicePrincipalRequest;
import com.databricks.sdk.service.iamv2.ResolveServicePrincipalResponse;
import com.databricks.sdk.service.iamv2.ResolveUserRequest;
import com.databricks.sdk.service.iamv2.ResolveUserResponse;
import com.databricks.sdk.service.iamv2.WorkspaceAccessDetail;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountIamV2Impl
implements AccountIamV2Service {
    private final ApiClient apiClient;

    public AccountIamV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public WorkspaceAccessDetail getWorkspaceAccessDetail(GetWorkspaceAccessDetailRequest request) {
        String path = String.format("/api/2.0/identity/accounts/%s/workspaces/%s/workspaceAccessDetails/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId(), request.getPrincipalId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WorkspaceAccessDetail.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResolveGroupResponse resolveGroup(ResolveGroupRequest request) {
        String path = String.format("/api/2.0/identity/accounts/%s/groups/resolveByExternalId", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ResolveGroupResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResolveServicePrincipalResponse resolveServicePrincipal(ResolveServicePrincipalRequest request) {
        String path = String.format("/api/2.0/identity/accounts/%s/servicePrincipals/resolveByExternalId", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ResolveServicePrincipalResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ResolveUserResponse resolveUser(ResolveUserRequest request) {
        String path = String.format("/api/2.0/identity/accounts/%s/users/resolveByExternalId", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ResolveUserResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

