/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.marketplace.CreateProviderRequest;
import com.databricks.sdk.service.marketplace.CreateProviderResponse;
import com.databricks.sdk.service.marketplace.DeleteProviderRequest;
import com.databricks.sdk.service.marketplace.GetProviderRequest;
import com.databricks.sdk.service.marketplace.GetProviderResponse;
import com.databricks.sdk.service.marketplace.ListProvidersRequest;
import com.databricks.sdk.service.marketplace.ListProvidersResponse;
import com.databricks.sdk.service.marketplace.ProviderInfo;
import com.databricks.sdk.service.marketplace.ProviderProvidersImpl;
import com.databricks.sdk.service.marketplace.ProviderProvidersService;
import com.databricks.sdk.service.marketplace.UpdateProviderRequest;
import com.databricks.sdk.service.marketplace.UpdateProviderResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderProvidersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderProvidersAPI.class);
    private final ProviderProvidersService impl;

    public ProviderProvidersAPI(ApiClient apiClient) {
        this.impl = new ProviderProvidersImpl(apiClient);
    }

    public ProviderProvidersAPI(ProviderProvidersService mock) {
        this.impl = mock;
    }

    public CreateProviderResponse create(CreateProviderRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteProviderRequest().setId(id));
    }

    public void delete(DeleteProviderRequest request) {
        this.impl.delete(request);
    }

    public GetProviderResponse get(String id) {
        return this.get(new GetProviderRequest().setId(id));
    }

    public GetProviderResponse get(GetProviderRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ProviderInfo> list(ListProvidersRequest request) {
        return new Paginator(request, this.impl::list, ListProvidersResponse::getProviders, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateProviderResponse update(UpdateProviderRequest request) {
        return this.impl.update(request);
    }

    public ProviderProvidersService impl() {
        return this.impl;
    }
}

