/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.Activity;
import com.databricks.sdk.service.ml.ApproveTransitionRequest;
import com.databricks.sdk.service.ml.ApproveTransitionRequestResponse;
import com.databricks.sdk.service.ml.CreateComment;
import com.databricks.sdk.service.ml.CreateCommentResponse;
import com.databricks.sdk.service.ml.CreateModelRequest;
import com.databricks.sdk.service.ml.CreateModelResponse;
import com.databricks.sdk.service.ml.CreateModelVersionRequest;
import com.databricks.sdk.service.ml.CreateModelVersionResponse;
import com.databricks.sdk.service.ml.CreateRegistryWebhook;
import com.databricks.sdk.service.ml.CreateTransitionRequest;
import com.databricks.sdk.service.ml.CreateTransitionRequestResponse;
import com.databricks.sdk.service.ml.CreateWebhookResponse;
import com.databricks.sdk.service.ml.DeleteCommentRequest;
import com.databricks.sdk.service.ml.DeleteModelRequest;
import com.databricks.sdk.service.ml.DeleteModelTagRequest;
import com.databricks.sdk.service.ml.DeleteModelVersionRequest;
import com.databricks.sdk.service.ml.DeleteModelVersionTagRequest;
import com.databricks.sdk.service.ml.DeleteTransitionRequestRequest;
import com.databricks.sdk.service.ml.DeleteTransitionRequestResponse;
import com.databricks.sdk.service.ml.DeleteWebhookRequest;
import com.databricks.sdk.service.ml.GetLatestVersionsRequest;
import com.databricks.sdk.service.ml.GetLatestVersionsResponse;
import com.databricks.sdk.service.ml.GetModelRequest;
import com.databricks.sdk.service.ml.GetModelResponse;
import com.databricks.sdk.service.ml.GetModelVersionDownloadUriRequest;
import com.databricks.sdk.service.ml.GetModelVersionDownloadUriResponse;
import com.databricks.sdk.service.ml.GetModelVersionRequest;
import com.databricks.sdk.service.ml.GetModelVersionResponse;
import com.databricks.sdk.service.ml.GetRegisteredModelPermissionLevelsRequest;
import com.databricks.sdk.service.ml.GetRegisteredModelPermissionLevelsResponse;
import com.databricks.sdk.service.ml.GetRegisteredModelPermissionsRequest;
import com.databricks.sdk.service.ml.ListModelsRequest;
import com.databricks.sdk.service.ml.ListModelsResponse;
import com.databricks.sdk.service.ml.ListRegistryWebhooks;
import com.databricks.sdk.service.ml.ListTransitionRequestsRequest;
import com.databricks.sdk.service.ml.ListTransitionRequestsResponse;
import com.databricks.sdk.service.ml.ListWebhooksRequest;
import com.databricks.sdk.service.ml.Model;
import com.databricks.sdk.service.ml.ModelRegistryImpl;
import com.databricks.sdk.service.ml.ModelRegistryService;
import com.databricks.sdk.service.ml.ModelVersion;
import com.databricks.sdk.service.ml.RegisteredModelPermissions;
import com.databricks.sdk.service.ml.RegisteredModelPermissionsRequest;
import com.databricks.sdk.service.ml.RegistryWebhook;
import com.databricks.sdk.service.ml.RejectTransitionRequest;
import com.databricks.sdk.service.ml.RejectTransitionRequestResponse;
import com.databricks.sdk.service.ml.RenameModelRequest;
import com.databricks.sdk.service.ml.RenameModelResponse;
import com.databricks.sdk.service.ml.SearchModelVersionsRequest;
import com.databricks.sdk.service.ml.SearchModelVersionsResponse;
import com.databricks.sdk.service.ml.SearchModelsRequest;
import com.databricks.sdk.service.ml.SearchModelsResponse;
import com.databricks.sdk.service.ml.SetModelTagRequest;
import com.databricks.sdk.service.ml.SetModelVersionTagRequest;
import com.databricks.sdk.service.ml.TestRegistryWebhookRequest;
import com.databricks.sdk.service.ml.TestRegistryWebhookResponse;
import com.databricks.sdk.service.ml.TransitionModelVersionStageDatabricks;
import com.databricks.sdk.service.ml.TransitionStageResponse;
import com.databricks.sdk.service.ml.UpdateComment;
import com.databricks.sdk.service.ml.UpdateCommentResponse;
import com.databricks.sdk.service.ml.UpdateModelRequest;
import com.databricks.sdk.service.ml.UpdateModelResponse;
import com.databricks.sdk.service.ml.UpdateModelVersionRequest;
import com.databricks.sdk.service.ml.UpdateModelVersionResponse;
import com.databricks.sdk.service.ml.UpdateRegistryWebhook;
import com.databricks.sdk.service.ml.UpdateWebhookResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ModelRegistryAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ModelRegistryAPI.class);
    private final ModelRegistryService impl;

    public ModelRegistryAPI(ApiClient apiClient) {
        this.impl = new ModelRegistryImpl(apiClient);
    }

    public ModelRegistryAPI(ModelRegistryService mock) {
        this.impl = mock;
    }

    public ApproveTransitionRequestResponse approveTransitionRequest(ApproveTransitionRequest request) {
        return this.impl.approveTransitionRequest(request);
    }

    public CreateCommentResponse createComment(CreateComment request) {
        return this.impl.createComment(request);
    }

    public CreateModelResponse createModel(CreateModelRequest request) {
        return this.impl.createModel(request);
    }

    public CreateModelVersionResponse createModelVersion(CreateModelVersionRequest request) {
        return this.impl.createModelVersion(request);
    }

    public CreateTransitionRequestResponse createTransitionRequest(CreateTransitionRequest request) {
        return this.impl.createTransitionRequest(request);
    }

    public CreateWebhookResponse createWebhook(CreateRegistryWebhook request) {
        return this.impl.createWebhook(request);
    }

    public void deleteComment(String id) {
        this.deleteComment(new DeleteCommentRequest().setId(id));
    }

    public void deleteComment(DeleteCommentRequest request) {
        this.impl.deleteComment(request);
    }

    public void deleteModel(String name) {
        this.deleteModel(new DeleteModelRequest().setName(name));
    }

    public void deleteModel(DeleteModelRequest request) {
        this.impl.deleteModel(request);
    }

    public void deleteModelTag(String name, String key) {
        this.deleteModelTag(new DeleteModelTagRequest().setName(name).setKey(key));
    }

    public void deleteModelTag(DeleteModelTagRequest request) {
        this.impl.deleteModelTag(request);
    }

    public void deleteModelVersion(String name, String version) {
        this.deleteModelVersion(new DeleteModelVersionRequest().setName(name).setVersion(version));
    }

    public void deleteModelVersion(DeleteModelVersionRequest request) {
        this.impl.deleteModelVersion(request);
    }

    public void deleteModelVersionTag(String name, String version, String key) {
        this.deleteModelVersionTag(new DeleteModelVersionTagRequest().setName(name).setVersion(version).setKey(key));
    }

    public void deleteModelVersionTag(DeleteModelVersionTagRequest request) {
        this.impl.deleteModelVersionTag(request);
    }

    public DeleteTransitionRequestResponse deleteTransitionRequest(String name, String version, String stage, String creator) {
        return this.deleteTransitionRequest(new DeleteTransitionRequestRequest().setName(name).setVersion(version).setStage(stage).setCreator(creator));
    }

    public DeleteTransitionRequestResponse deleteTransitionRequest(DeleteTransitionRequestRequest request) {
        return this.impl.deleteTransitionRequest(request);
    }

    public void deleteWebhook(String id) {
        this.deleteWebhook(new DeleteWebhookRequest().setId(id));
    }

    public void deleteWebhook(DeleteWebhookRequest request) {
        this.impl.deleteWebhook(request);
    }

    public Iterable<ModelVersion> getLatestVersions(GetLatestVersionsRequest request) {
        return new Paginator(request, this.impl::getLatestVersions, GetLatestVersionsResponse::getModelVersions, response -> null);
    }

    public GetModelResponse getModel(String name) {
        return this.getModel(new GetModelRequest().setName(name));
    }

    public GetModelResponse getModel(GetModelRequest request) {
        return this.impl.getModel(request);
    }

    public GetModelVersionResponse getModelVersion(String name, String version) {
        return this.getModelVersion(new GetModelVersionRequest().setName(name).setVersion(version));
    }

    public GetModelVersionResponse getModelVersion(GetModelVersionRequest request) {
        return this.impl.getModelVersion(request);
    }

    public GetModelVersionDownloadUriResponse getModelVersionDownloadUri(String name, String version) {
        return this.getModelVersionDownloadUri(new GetModelVersionDownloadUriRequest().setName(name).setVersion(version));
    }

    public GetModelVersionDownloadUriResponse getModelVersionDownloadUri(GetModelVersionDownloadUriRequest request) {
        return this.impl.getModelVersionDownloadUri(request);
    }

    public GetRegisteredModelPermissionLevelsResponse getPermissionLevels(String registeredModelId) {
        return this.getPermissionLevels(new GetRegisteredModelPermissionLevelsRequest().setRegisteredModelId(registeredModelId));
    }

    public GetRegisteredModelPermissionLevelsResponse getPermissionLevels(GetRegisteredModelPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public RegisteredModelPermissions getPermissions(String registeredModelId) {
        return this.getPermissions(new GetRegisteredModelPermissionsRequest().setRegisteredModelId(registeredModelId));
    }

    public RegisteredModelPermissions getPermissions(GetRegisteredModelPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<Model> listModels(ListModelsRequest request) {
        return new Paginator(request, this.impl::listModels, ListModelsResponse::getRegisteredModels, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Activity> listTransitionRequests(String name, String version) {
        return this.listTransitionRequests(new ListTransitionRequestsRequest().setName(name).setVersion(version));
    }

    public Iterable<Activity> listTransitionRequests(ListTransitionRequestsRequest request) {
        return new Paginator(request, this.impl::listTransitionRequests, ListTransitionRequestsResponse::getRequests, response -> null);
    }

    public Iterable<RegistryWebhook> listWebhooks(ListWebhooksRequest request) {
        return new Paginator(request, this.impl::listWebhooks, ListRegistryWebhooks::getWebhooks, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public RejectTransitionRequestResponse rejectTransitionRequest(RejectTransitionRequest request) {
        return this.impl.rejectTransitionRequest(request);
    }

    public RenameModelResponse renameModel(RenameModelRequest request) {
        return this.impl.renameModel(request);
    }

    public Iterable<ModelVersion> searchModelVersions(SearchModelVersionsRequest request) {
        return new Paginator(request, this.impl::searchModelVersions, SearchModelVersionsResponse::getModelVersions, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Model> searchModels(SearchModelsRequest request) {
        return new Paginator(request, this.impl::searchModels, SearchModelsResponse::getRegisteredModels, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void setModelTag(SetModelTagRequest request) {
        this.impl.setModelTag(request);
    }

    public void setModelVersionTag(SetModelVersionTagRequest request) {
        this.impl.setModelVersionTag(request);
    }

    public RegisteredModelPermissions setPermissions(RegisteredModelPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public TestRegistryWebhookResponse testRegistryWebhook(TestRegistryWebhookRequest request) {
        return this.impl.testRegistryWebhook(request);
    }

    public TransitionStageResponse transitionStage(TransitionModelVersionStageDatabricks request) {
        return this.impl.transitionStage(request);
    }

    public UpdateCommentResponse updateComment(UpdateComment request) {
        return this.impl.updateComment(request);
    }

    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        return this.impl.updateModel(request);
    }

    public UpdateModelVersionResponse updateModelVersion(UpdateModelVersionRequest request) {
        return this.impl.updateModelVersion(request);
    }

    public RegisteredModelPermissions updatePermissions(RegisteredModelPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public UpdateWebhookResponse updateWebhook(UpdateRegistryWebhook request) {
        return this.impl.updateWebhook(request);
    }

    public ModelRegistryService impl() {
        return this.impl;
    }
}

