/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settings.CreateIpAccessList;
import com.databricks.sdk.service.settings.CreateIpAccessListResponse;
import com.databricks.sdk.service.settings.DeleteIpAccessListRequest;
import com.databricks.sdk.service.settings.FetchIpAccessListResponse;
import com.databricks.sdk.service.settings.GetIpAccessListRequest;
import com.databricks.sdk.service.settings.IpAccessListsService;
import com.databricks.sdk.service.settings.ListIpAccessListResponse;
import com.databricks.sdk.service.settings.ReplaceIpAccessList;
import com.databricks.sdk.service.settings.UpdateIpAccessList;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class IpAccessListsImpl
implements IpAccessListsService {
    private final ApiClient apiClient;

    public IpAccessListsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateIpAccessListResponse create(CreateIpAccessList request) {
        String path = "/api/2.0/ip-access-lists";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateIpAccessListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteIpAccessListRequest request) {
        String path = String.format("/api/2.0/ip-access-lists/%s", request.getIpAccessListId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public FetchIpAccessListResponse get(GetIpAccessListRequest request) {
        String path = String.format("/api/2.0/ip-access-lists/%s", request.getIpAccessListId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, FetchIpAccessListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListIpAccessListResponse list() {
        String path = "/api/2.0/ip-access-lists";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListIpAccessListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void replace(ReplaceIpAccessList request) {
        String path = String.format("/api/2.0/ip-access-lists/%s", request.getIpAccessListId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateIpAccessList request) {
        String path = String.format("/api/2.0/ip-access-lists/%s", request.getIpAccessListId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

