/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sharing.CreateFederationPolicyRequest;
import com.databricks.sdk.service.sharing.DeleteFederationPolicyRequest;
import com.databricks.sdk.service.sharing.FederationPolicy;
import com.databricks.sdk.service.sharing.GetFederationPolicyRequest;
import com.databricks.sdk.service.sharing.ListFederationPoliciesRequest;
import com.databricks.sdk.service.sharing.ListFederationPoliciesResponse;
import com.databricks.sdk.service.sharing.RecipientFederationPoliciesImpl;
import com.databricks.sdk.service.sharing.RecipientFederationPoliciesService;
import com.databricks.sdk.service.sharing.UpdateFederationPolicyRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class RecipientFederationPoliciesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientFederationPoliciesAPI.class);
    private final RecipientFederationPoliciesService impl;

    public RecipientFederationPoliciesAPI(ApiClient apiClient) {
        this.impl = new RecipientFederationPoliciesImpl(apiClient);
    }

    public RecipientFederationPoliciesAPI(RecipientFederationPoliciesService mock) {
        this.impl = mock;
    }

    public FederationPolicy create(CreateFederationPolicyRequest request) {
        return this.impl.create(request);
    }

    public void delete(String recipientName, String name) {
        this.delete(new DeleteFederationPolicyRequest().setRecipientName(recipientName).setName(name));
    }

    public void delete(DeleteFederationPolicyRequest request) {
        this.impl.delete(request);
    }

    public FederationPolicy getFederationPolicy(String recipientName, String name) {
        return this.getFederationPolicy(new GetFederationPolicyRequest().setRecipientName(recipientName).setName(name));
    }

    public FederationPolicy getFederationPolicy(GetFederationPolicyRequest request) {
        return this.impl.getFederationPolicy(request);
    }

    public Iterable<FederationPolicy> list(String recipientName) {
        return this.list(new ListFederationPoliciesRequest().setRecipientName(recipientName));
    }

    public Iterable<FederationPolicy> list(ListFederationPoliciesRequest request) {
        return new Paginator(request, this.impl::list, ListFederationPoliciesResponse::getPolicies, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public FederationPolicy update(UpdateFederationPolicyRequest request) {
        return this.impl.update(request);
    }

    public RecipientFederationPoliciesService impl() {
        return this.impl;
    }
}

