/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sharing.CreateShare;
import com.databricks.sdk.service.sharing.DeleteShareRequest;
import com.databricks.sdk.service.sharing.GetSharePermissionsResponse;
import com.databricks.sdk.service.sharing.GetShareRequest;
import com.databricks.sdk.service.sharing.ListSharesResponse;
import com.databricks.sdk.service.sharing.ShareInfo;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.SharesExtAPI;
import com.databricks.sdk.service.sharing.SharesListRequest;
import com.databricks.sdk.service.sharing.SharesService;
import com.databricks.sdk.service.sharing.UpdateShare;
import com.databricks.sdk.service.sharing.UpdateSharePermissions;
import com.databricks.sdk.service.sharing.UpdateSharePermissionsResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class SharesAPI
extends SharesExtAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SharesAPI.class);

    public SharesAPI(ApiClient apiClient) {
        super(apiClient);
    }

    public SharesAPI(SharesService mock) {
        super(mock);
    }

    public ShareInfo create(CreateShare request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteShareRequest().setName(name));
    }

    public void delete(DeleteShareRequest request) {
        this.impl.delete(request);
    }

    public ShareInfo get(String name) {
        return this.get(new GetShareRequest().setName(name));
    }

    public ShareInfo get(GetShareRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ShareInfo> listShares(SharesListRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::listShares, ListSharesResponse::getShares, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public GetSharePermissionsResponse sharePermissions(String name) {
        return this.sharePermissions(new SharePermissionsRequest().setName(name));
    }

    public GetSharePermissionsResponse sharePermissions(SharePermissionsRequest request) {
        return this.impl.sharePermissions(request);
    }

    public ShareInfo update(UpdateShare request) {
        return this.impl.update(request);
    }

    public UpdateSharePermissionsResponse updatePermissions(UpdateSharePermissions request) {
        return this.impl.updatePermissions(request);
    }

    public SharesService impl() {
        return this.impl;
    }
}

