/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.billing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.billing.Budget;
import com.databricks.sdk.service.billing.BudgetWithStatus;
import com.databricks.sdk.service.billing.BudgetsImpl;
import com.databricks.sdk.service.billing.BudgetsService;
import com.databricks.sdk.service.billing.DeleteBudgetRequest;
import com.databricks.sdk.service.billing.GetBudgetRequest;
import com.databricks.sdk.service.billing.WrappedBudget;
import com.databricks.sdk.service.billing.WrappedBudgetWithStatus;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class BudgetsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(BudgetsAPI.class);
    private final BudgetsService impl;

    public BudgetsAPI(ApiClient apiClient) {
        this.impl = new BudgetsImpl(apiClient);
    }

    public BudgetsAPI(BudgetsService mock) {
        this.impl = mock;
    }

    public WrappedBudgetWithStatus create(Budget budget) {
        return this.create(new WrappedBudget().setBudget(budget));
    }

    public WrappedBudgetWithStatus create(WrappedBudget request) {
        return this.impl.create(request);
    }

    public void delete(String budgetId) {
        this.delete(new DeleteBudgetRequest().setBudgetId(budgetId));
    }

    public void delete(DeleteBudgetRequest request) {
        this.impl.delete(request);
    }

    public WrappedBudgetWithStatus get(String budgetId) {
        return this.get(new GetBudgetRequest().setBudgetId(budgetId));
    }

    public WrappedBudgetWithStatus get(GetBudgetRequest request) {
        return this.impl.get(request);
    }

    public Iterable<BudgetWithStatus> list() {
        return this.impl.list().getBudgets();
    }

    public void update(Budget budget, String budgetId) {
        this.update(new WrappedBudget().setBudget(budget).setBudgetId(budgetId));
    }

    public void update(WrappedBudget request) {
        this.impl.update(request);
    }

    public BudgetsService impl() {
        return this.impl;
    }
}

