/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.DeleteUserRequest;
import com.databricks.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.sdk.service.iam.GetUserRequest;
import com.databricks.sdk.service.iam.ListUsersRequest;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.PasswordPermissions;
import com.databricks.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.service.iam.UsersImpl;
import com.databricks.sdk.service.iam.UsersService;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class UsersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(UsersAPI.class);
    private final UsersService impl;

    public UsersAPI(ApiClient apiClient) {
        this.impl = new UsersImpl(apiClient);
    }

    public UsersAPI(UsersService mock) {
        this.impl = mock;
    }

    public User create(User request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteUserRequest().setId(id));
    }

    public void delete(DeleteUserRequest request) {
        this.impl.delete(request);
    }

    public User get(String id) {
        return this.get(new GetUserRequest().setId(id));
    }

    public User get(GetUserRequest request) {
        return this.impl.get(request);
    }

    public GetPasswordPermissionLevelsResponse getPasswordPermissionLevels() {
        return this.impl.getPasswordPermissionLevels();
    }

    public PasswordPermissions getPasswordPermissions() {
        return this.impl.getPasswordPermissions();
    }

    public Iterable<User> list(ListUsersRequest request) {
        return this.impl.list(request).getResources();
    }

    public void patch(String id) {
        this.patch(new PartialUpdate().setId(id));
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public PasswordPermissions setPasswordPermissions(PasswordPermissionsRequest request) {
        return this.impl.setPasswordPermissions(request);
    }

    public void update(String id) {
        this.update(new User().setId(id));
    }

    public void update(User request) {
        this.impl.update(request);
    }

    public PasswordPermissions updatePasswordPermissions(PasswordPermissionsRequest request) {
        return this.impl.updatePasswordPermissions(request);
    }

    public UsersService impl() {
        return this.impl;
    }
}

