/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.provisioning.CreateCredentialRequest;
import com.databricks.sdk.service.provisioning.Credential;
import com.databricks.sdk.service.provisioning.CredentialsService;
import com.databricks.sdk.service.provisioning.DeleteCredentialRequest;
import com.databricks.sdk.service.provisioning.GetCredentialRequest;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import java.util.HashMap;

@Generated
class CredentialsImpl
implements CredentialsService {
    private final ApiClient apiClient;

    public CredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Credential create(CreateCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/credentials", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Credential.class, headers);
    }

    @Override
    public void delete(DeleteCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/credentials/%s", this.apiClient.configuredAccountID(), request.getCredentialsId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public Credential get(GetCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/credentials/%s", this.apiClient.configuredAccountID(), request.getCredentialsId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Credential.class, headers);
    }

    @Override
    public Collection<Credential> list() {
        String path = String.format("/api/2.0/accounts/%s/credentials", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.getCollection(path, null, Credential.class, headers);
    }
}

