/*
 * Decompiled with CFR 0.152.
 */
package com.databricks;

import com.databricks.GeoUtils;
import java.net.URL;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class GeoUtils$
implements App {
    public static final GeoUtils$ MODULE$;
    private List<GeoUtils.Country> countries;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile boolean bitmap$0;

    static {
        new GeoUtils$();
    }

    private List countries$lzycompute() {
        GeoUtils$ geoUtils$ = this;
        synchronized (geoUtils$) {
            if (!this.bitmap$0) {
                URL geocodesUrl = this.getClass().getClassLoader().getResource("country_geocodes.csv");
                if (geocodesUrl == null) {
                    throw new IllegalStateException("Could not find 'country_geocodes.csv' to perform reverse geo lookups");
                }
                Iterator geocodes = Source$.MODULE$.fromURL(geocodesUrl, Codec$.MODULE$.fallbackSystemCodec()).getLines();
                geocodes.next();
                this.countries = geocodes.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply(String x$1) {
                        return x$1.split(",");
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final GeoUtils.Country apply(String[] x0$1) {
                        String[] stringArray = x0$1;
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
                            String code3L = (String)((SeqLike)option.get()).apply(1);
                            String latitude = (String)((SeqLike)option.get()).apply(2);
                            String longitude = (String)((SeqLike)option.get()).apply(3);
                            GeoUtils.Country country = new GeoUtils.Country(code3L, new StringOps(Predef$.MODULE$.augmentString(latitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(longitude)).toDouble());
                            return country;
                        }
                        throw new MatchError((Object)stringArray);
                    }
                }).toList();
                this.bitmap$0 = true;
            }
            return this.countries;
        }
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body) {
        App.class.delayedInit((App)this, body);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    private List<GeoUtils.Country> countries() {
        return this.bitmap$0 ? this.countries : this.countries$lzycompute();
    }

    public String getClosestCountry(double latitude, double longitude) {
        return ((GeoUtils.Country)((Tuple2)((TraversableOnce)this.countries().map((Function1)new Serializable(latitude, longitude){
            public static final long serialVersionUID = 0L;
            private final double latitude$1;
            private final double longitude$1;

            public final Tuple2<Object, GeoUtils.Country> apply(GeoUtils.Country country) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)GeoUtils$.MODULE$.com$databricks$GeoUtils$$haversine(this.latitude$1, this.longitude$1, country.latitude(), country.longitude())), (Object)country);
            }
            {
                this.latitude$1 = latitude$1;
                this.longitude$1 = longitude$1;
            }
        }, List$.MODULE$.canBuildFrom())).minBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, GeoUtils.Country> x$2) {
                return x$2._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$))._2()).code();
    }

    public double com$databricks$GeoUtils$$haversine(double lat1, double lon1, double lat2, double lon2) {
        double R = 6372.8;
        double dLat = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(lat2 - lat1));
        double dLon = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(lon2 - lon1));
        double a = package$.MODULE$.pow(package$.MODULE$.sin(dLat / (double)2), 2.0) + package$.MODULE$.pow(package$.MODULE$.sin(dLon / (double)2), 2.0) * package$.MODULE$.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(lat1))) * package$.MODULE$.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(lat2)));
        double c = (double)2 * package$.MODULE$.asin(package$.MODULE$.sqrt(a));
        return R * c;
    }

    private GeoUtils$() {
        MODULE$ = this;
        App.class.$init$((App)this);
    }
}

