/*
 * Decompiled with CFR 0.152.
 */
package sjsonnet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.json.JSONObject;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Platform$ {
    public static final Platform$ MODULE$ = new Platform$();
    private static final XXHashFactory xxHashFactory = XXHashFactory.fastestInstance();

    public String gzipBytes(byte[] b) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(b.length);
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(b);
        gzip.close();
        String gzippedBase64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
        outputStream.close();
        return gzippedBase64;
    }

    public String gzipString(String s) {
        return this.gzipBytes(s.getBytes());
    }

    public String xzBytes(byte[] b, Option<Object> compressionLevel) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(b.length);
        int level = BoxesRunTime.unboxToInt((Object)compressionLevel.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 6));
        XZOutputStream xz = new XZOutputStream((OutputStream)outputStream, (FilterOptions)new LZMA2Options(level));
        xz.write(b);
        xz.close();
        String xzedBase64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
        outputStream.close();
        return xzedBase64;
    }

    public String xzString(String s, Option<Object> compressionLevel) {
        return this.xzBytes(s.getBytes(), compressionLevel);
    }

    public String yamlToJson(String yamlString) {
        LinkedHashMap yaml = (LinkedHashMap)new Yaml((BaseConstructor)new Constructor(LinkedHashMap.class)).load(yamlString);
        return new JSONObject((Map)yaml).toString();
    }

    public String md5(String s) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(MessageDigest.getInstance("MD5").digest(s.getBytes("UTF-8"))), (Function1 & Serializable)b -> Platform$.$anonfun$md5$1(BoxesRunTime.unboxToByte((Object)b)), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    public String hashFile(File file) {
        byte[] buffer = new byte[8192];
        StreamingXXHash64 hash = xxHashFactory.newStreamingHash64(0L);
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            int bytesRead = bis.read(buffer);
            while (bytesRead != -1) {
                hash.update(buffer, 0, bytesRead);
                bytesRead = bis.read(buffer);
            }
        }
        finally {
            bis.close();
            fis.close();
        }
        return ((Object)BoxesRunTime.boxToLong((long)hash.getValue())).toString();
    }

    public static final /* synthetic */ String $anonfun$md5$1(byte b) {
        return String.format("%02x", new Integer(b & 0xFF));
    }

    private Platform$() {
    }
}

