/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.csv;

import com.databricks.spark.csv.CsvRelation;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;

public class JavaCsvParser {
    private Boolean useHeader = true;
    private Character delimiter = Character.valueOf(',');
    private Character quote = Character.valueOf('\"');
    private StructType schema = null;

    public JavaCsvParser withUseHeader(Boolean bl) {
        this.useHeader = bl;
        return this;
    }

    public JavaCsvParser withDelimiter(Character c) {
        this.delimiter = c;
        return this;
    }

    public JavaCsvParser withQuoteChar(Character c) {
        this.quote = c;
        return this;
    }

    public JavaCsvParser withSchema(StructType structType) {
        this.schema = structType;
        return this;
    }

    public DataFrame csvFile(SQLContext sQLContext, String string) {
        CsvRelation csvRelation = new CsvRelation(string, this.useHeader, this.delimiter.charValue(), this.quote.charValue(), this.schema, sQLContext);
        return sQLContext.baseRelationToDataFrame((BaseRelation)csvRelation);
    }
}

