/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.csv;

import com.databricks.spark.csv.CsvRelation$;
import com.databricks.spark.csv.package;
import com.databricks.spark.csv.package$;
import com.databricks.spark.csv.util.ParseModes$;
import com.databricks.spark.csv.util.ParserLibs$;
import com.databricks.spark.csv.util.TypeCast$;
import com.databricks.spark.sql.readers.BulkCsvReader;
import com.databricks.spark.sql.readers.BulkCsvReader$;
import com.databricks.spark.sql.readers.LineCsvReader;
import com.databricks.spark.sql.readers.LineCsvReader$;
import java.io.IOException;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001B\u0001\u0003\u0001.\u00111bQ:w%\u0016d\u0017\r^5p]*\u00111\u0001B\u0001\u0004GN4(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0006eCR\f'M]5dWNT\u0011!C\u0001\u0004G>l7\u0001A\n\u0007\u00011IBdH\u0013\u0011\u000559R\"\u0001\b\u000b\u0005=\u0001\u0012aB:pkJ\u001cWm\u001d\u0006\u0003#I\t1a]9m\u0015\t)1C\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<\u0017B\u0001\r\u000f\u00051\u0011\u0015m]3SK2\fG/[8o!\ti!$\u0003\u0002\u001c\u001d\tIA+\u00192mKN\u001b\u0017M\u001c\t\u0003\u001buI!A\b\b\u0003%%s7/\u001a:uC\ndWMU3mCRLwN\u001c\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\b!J|G-^2u!\t\u0001c%\u0003\u0002(C\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0006\u0001BK\u0002\u0013\u0005!&\u0001\u0005m_\u000e\fG/[8o+\u0005Y\u0003C\u0001\u00170\u001d\t\u0001S&\u0003\u0002/C\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq\u0013\u0005\u0003\u00054\u0001\tE\t\u0015!\u0003,\u0003%awnY1uS>t\u0007\u0005\u0003\u00056\u0001\tU\r\u0011\"\u00017\u0003%)8/\u001a%fC\u0012,'/F\u00018!\t\u0001\u0003(\u0003\u0002:C\t9!i\\8mK\u0006t\u0007\u0002C\u001e\u0001\u0005#\u0005\u000b\u0011B\u001c\u0002\u0015U\u001cX\rS3bI\u0016\u0014\b\u0005\u0003\u0005>\u0001\tU\r\u0011\"\u0001?\u0003%!W\r\\5nSR,'/F\u0001@!\t\u0001\u0003)\u0003\u0002BC\t!1\t[1s\u0011!\u0019\u0005A!E!\u0002\u0013y\u0014A\u00033fY&l\u0017\u000e^3sA!AQ\t\u0001BK\u0002\u0013\u0005a(A\u0003rk>$X\r\u0003\u0005H\u0001\tE\t\u0015!\u0003@\u0003\u0019\tXo\u001c;fA!A\u0011\n\u0001BK\u0002\u0013\u0005!*\u0001\u0004fg\u000e\f\u0007/Z\u000b\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0005Y\u0006twMC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ik%!C\"iCJ\f7\r^3s\u0011!!\u0006A!E!\u0002\u0013Y\u0015aB3tG\u0006\u0004X\r\t\u0005\t-\u0002\u0011)\u001a!C\u0001U\u0005I\u0001/\u0019:tK6{G-\u001a\u0005\t1\u0002\u0011\t\u0012)A\u0005W\u0005Q\u0001/\u0019:tK6{G-\u001a\u0011\t\u0011i\u0003!Q3A\u0005\u0002)\n\u0011\u0002]1sg\u0016\u0014H*\u001b2\t\u0011q\u0003!\u0011#Q\u0001\n-\n!\u0002]1sg\u0016\u0014H*\u001b2!\u0011!q\u0006A!f\u0001\n\u00031\u0014aF5h]>\u0014X\rT3bI&twm\u00165ji\u0016\u001c\u0006/Y2f\u0011!\u0001\u0007A!E!\u0002\u00139\u0014\u0001G5h]>\u0014X\rT3bI&twm\u00165ji\u0016\u001c\u0006/Y2fA!A!\r\u0001BK\u0002\u0013\u0005a'\u0001\rjO:|'/\u001a+sC&d\u0017N\\4XQ&$Xm\u00159bG\u0016D\u0001\u0002\u001a\u0001\u0003\u0012\u0003\u0006IaN\u0001\u001aS\u001etwN]3Ue\u0006LG.\u001b8h/\"LG/Z*qC\u000e,\u0007\u0005\u0003\u0005g\u0001\tU\r\u0011\"\u0001h\u0003))8/\u001a:TG\",W.Y\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eE\u0001\u0006if\u0004Xm]\u0005\u0003[*\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011!y\u0007A!E!\u0002\u0013A\u0017aC;tKJ\u001c6\r[3nC\u0002B\u0001\"\u001d\u0001\u0003\u0006\u0004%\tA]\u0001\u000bgFd7i\u001c8uKb$X#A:\u0011\u0005Q,X\"\u0001\t\n\u0005Y\u0004\"AC*R\u0019\u000e{g\u000e^3yi\"A\u0001\u0010\u0001B\u0001B\u0003%1/A\u0006tc2\u001cuN\u001c;fqR\u0004\u0003FA<{!\t\u000130\u0003\u0002}C\tIAO]1og&,g\u000e\u001e\u0005\u0007}\u0002!\t\u0002B@\u0002\rqJg.\u001b;?)Y\t\t!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005mA\u0003BA\u0002\u0003\u000f\u00012!!\u0002\u0001\u001b\u0005\u0011\u0001\"B9~\u0001\u0004\u0019\b\"B\u0015~\u0001\u0004Y\u0003\"B\u001b~\u0001\u00049\u0004\"B\u001f~\u0001\u0004y\u0004\"B#~\u0001\u0004y\u0004\"B%~\u0001\u0004Y\u0005\"\u0002,~\u0001\u0004Y\u0003\"\u0002.~\u0001\u0004Y\u0003\"\u00020~\u0001\u00049\u0004\"\u00022~\u0001\u00049\u0004b\u00024~!\u0003\u0005\r\u0001\u001b\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003C\ta\u0001\\8hO\u0016\u0014XCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015+\u0005)1\u000f\u001c45U&!\u0011QFA\u0014\u0005\u0019aunZ4fe\"A\u0011\u0011\u0007\u0001!\u0002\u0013\t\u0019#A\u0004m_\u001e<WM\u001d\u0011\t\u0011\u0005U\u0002A1A\u0005\nY\n\u0001BZ1jY\u001a\u000b7\u000f\u001e\u0005\b\u0003s\u0001\u0001\u0015!\u00038\u0003%1\u0017-\u001b7GCN$\b\u0005\u0003\u0005\u0002>\u0001\u0011\r\u0011\"\u00037\u00035!'o\u001c9NC24wN]7fI\"9\u0011\u0011\t\u0001!\u0002\u00139\u0014A\u00043s_Bl\u0015\r\u001c4pe6,G\r\t\u0005\t\u0003\u000b\u0002!\u0019!C\u0005m\u0005Q\u0001/\u001a:nSN\u001c\u0018N^3\t\u000f\u0005%\u0003\u0001)A\u0005o\u0005Y\u0001/\u001a:nSN\u001c\u0018N^3!\u0011!\ti\u0005\u0001b\u0001\n\u00039\u0017AB:dQ\u0016l\u0017\rC\u0004\u0002R\u0001\u0001\u000b\u0011\u00025\u0002\u000fM\u001c\u0007.Z7bA!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013!\u00032vS2$7kY1o)\t\tI\u0006\u0005\u0004\u0002\\\u0005\u0005\u0014QM\u0007\u0003\u0003;R1!a\u0018\u0013\u0003\r\u0011H\rZ\u0005\u0005\u0003G\niFA\u0002S\t\u0012\u00032\u0001^A4\u0013\r\tI\u0007\u0005\u0002\u0004%><\bbBA7\u0001\u0011%\u0011qN\u0001\fS:4WM]*dQ\u0016l\u0017\rF\u0001i\u0011%\t\u0019\b\u0001EC\u0002\u0013%!&A\u0005gSJ\u001cH\u000fT5oK\"I\u0011q\u000f\u0001\t\u0002\u0003\u0006KaK\u0001\u000bM&\u00148\u000f\u001e'j]\u0016\u0004\u0003bBA>\u0001\u0011%\u0011QP\u0001\u0012k:Lgo\\2jif\u0004\u0016M]:f\u0007N3F\u0003CA-\u0003\u007f\n))!)\t\u0011\u0005\u0005\u0015\u0011\u0010a\u0001\u0003\u0007\u000bAAZ5mKB)\u00111LA1W!A\u0011qQA=\u0001\u0004\tI)\u0001\u0004iK\u0006$WM\u001d\t\u0006\u0003\u0017\u000bYj\u000b\b\u0005\u0003\u001b\u000b9J\u0004\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019JC\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ1!!'\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!!(\u0002 \n\u00191+Z9\u000b\u0007\u0005e\u0015\u0005\u0003\u0005\u0002$\u0006e\u0004\u0019AAS\u00031\u00198\r[3nC\u001aKW\r\u001c3t!\u0019\tY)a'\u0002(B\u0019\u0011.!+\n\u0007\u0005-&NA\u0006TiJ,8\r\u001e$jK2$\u0007bBAX\u0001\u0011%\u0011\u0011W\u0001\ta\u0006\u00148/Z\"T-RA\u00111WA]\u0003\u007f\u000b\t\u000e\u0005\u0004\u0002\f\u0006U\u0016QM\u0005\u0005\u0003o\u000byJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011!\tY,!,A\u0002\u0005u\u0016\u0001B5uKJ\u0004R!a#\u00026.B\u0001\"!1\u0002.\u0002\u0007\u00111Y\u0001\nGN4hi\u001c:nCR\u0004B!!2\u0002N6\u0011\u0011q\u0019\u0006\u0004\u0007\u0005%'bAAf'\u000591m\\7n_:\u001c\u0018\u0002BAh\u0003\u000f\u0014\u0011bQ*W\r>\u0014X.\u0019;\t\u0011\u0005\r\u0016Q\u0016a\u0001\u0003KCq!!6\u0001\t\u0003\n9.\u0001\u0004j]N,'\u000f\u001e\u000b\u0007\u00033\fy.!;\u0011\u0007\u0001\nY.C\u0002\u0002^\u0006\u0012A!\u00168ji\"A\u0011\u0011]Aj\u0001\u0004\t\u0019/\u0001\u0003eCR\f\u0007c\u0001;\u0002f&\u0019\u0011q\u001d\t\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007bBAv\u0003'\u0004\raN\u0001\n_Z,'o\u001e:ji\u0016D\u0011\"a<\u0001\u0003\u0003%\t!!=\u0002\t\r|\u0007/\u001f\u000b\u0017\u0003g\f90!?\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)Aa\u0002\u0003\nQ!\u00111AA{\u0011\u0019\t\u0018Q\u001ea\u0001g\"A\u0011&!<\u0011\u0002\u0003\u00071\u0006\u0003\u00056\u0003[\u0004\n\u00111\u00018\u0011!i\u0014Q\u001eI\u0001\u0002\u0004y\u0004\u0002C#\u0002nB\u0005\t\u0019A \t\u0011%\u000bi\u000f%AA\u0002-C\u0001BVAw!\u0003\u0005\ra\u000b\u0005\t5\u00065\b\u0013!a\u0001W!Aa,!<\u0011\u0002\u0003\u0007q\u0007\u0003\u0005c\u0003[\u0004\n\u00111\u00018\u0011!1\u0017Q\u001eI\u0001\u0002\u0004A\u0007\"\u0003B\u0007\u0001E\u0005I\u0011\u0001B\b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0005+\u0007-\u0012\u0019b\u000b\u0002\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011!C;oG\",7m[3e\u0015\r\u0011y\"I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0012\u00053\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00119\u0003AI\u0001\n\u0003\u0011I#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-\"fA\u001c\u0003\u0014!I!q\u0006\u0001\u0012\u0002\u0013\u0005!\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019DK\u0002@\u0005'A\u0011Ba\u000e\u0001#\u0003%\tA!\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!I!1\b\u0001\u0012\u0002\u0013\u0005!QH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011yDK\u0002L\u0005'A\u0011Ba\u0011\u0001#\u0003%\tAa\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m!I!q\t\u0001\u0012\u0002\u0013\u0005!qB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u0011%\u0011Y\u0005AI\u0001\n\u0003\u0011I#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\t\u0013\t=\u0003!%A\u0005\u0002\t%\u0012AD2paf$C-\u001a4bk2$H%\u000f\u0005\n\u0005'\u0002\u0011\u0013!C\u0001\u0005+\nqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005/R3\u0001\u001bB\n\u0011%\u0011Y\u0006AA\u0001\n\u0003\u0012i&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005?\u00022\u0001\u0014B1\u0013\t\u0001T\nC\u0005\u0003f\u0001\t\t\u0011\"\u0001\u0003h\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\u000e\t\u0004A\t-\u0014b\u0001B7C\t\u0019\u0011J\u001c;\t\u0013\tE\u0004!!A\u0005\u0002\tM\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005k\u0012Y\bE\u0002!\u0005oJ1A!\u001f\"\u0005\r\te.\u001f\u0005\u000b\u0005{\u0012y'!AA\u0002\t%\u0014a\u0001=%c!I!\u0011\u0011\u0001\u0002\u0002\u0013\u0005#1Q\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0011\t\u0007\u0005\u000f\u0013iI!\u001e\u000e\u0005\t%%b\u0001BFC\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]&\u0011\u0012\u0005\n\u0005#\u0003\u0011\u0011!C\u0001\u0005'\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004o\tU\u0005B\u0003B?\u0005\u001f\u000b\t\u00111\u0001\u0003v!I!\u0011\u0014\u0001\u0002\u0002\u0013\u0005#1T\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011\u000e\u0005\n\u0005?\u0003\u0011\u0011!C!\u0005C\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005?B\u0011B!*\u0001\u0003\u0003%\tEa*\u0002\r\u0015\fX/\u00197t)\r9$\u0011\u0016\u0005\u000b\u0005{\u0012\u0019+!AA\u0002\tUt!\u0003BW\u0005\u0005\u0005\t\u0012\u0001BX\u0003-\u00195O\u001e*fY\u0006$\u0018n\u001c8\u0011\t\u0005\u0015!\u0011\u0017\u0004\t\u0003\t\t\t\u0011#\u0001\u00034N)!\u0011\u0017B[KA\u0019\u0001Ea.\n\u0007\te\u0016E\u0001\u0004B]f\u0014VM\u001a\u0005\b}\nEF\u0011\u0001B_)\t\u0011y\u000b\u0003\u0006\u0003 \nE\u0016\u0011!C#\u0005CC!Ba1\u00032\u0006\u0005I\u0011\u0011Bc\u0003\u0015\t\u0007\u000f\u001d7z)Y\u00119M!4\u0003P\nE'1\u001bBk\u0005/\u0014INa7\u0003^\n}G\u0003BA\u0002\u0005\u0013Da!\u001dBa\u0001\u0004\u0019\bf\u0001Beu\"1\u0011F!1A\u0002-Ba!\u000eBa\u0001\u00049\u0004BB\u001f\u0003B\u0002\u0007q\b\u0003\u0004F\u0005\u0003\u0004\ra\u0010\u0005\u0007\u0013\n\u0005\u0007\u0019A&\t\rY\u0013\t\r1\u0001,\u0011\u0019Q&\u0011\u0019a\u0001W!1aL!1A\u0002]BaA\u0019Ba\u0001\u00049\u0004\u0002\u00034\u0003BB\u0005\t\u0019\u00015\t\u0015\t\r(\u0011WA\u0001\n\u0003\u0013)/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u001d(1\u001f\t\u0006A\t%(Q^\u0005\u0004\u0005W\f#AB(qi&|g\u000eE\u0007!\u0005_\\sgP LW-:t\u0007[\u0005\u0004\u0005c\f#a\u0002+va2,\u0017\u0007\r\u0005\u000b\u0005k\u0014\t/!AA\u0002\u0005\r\u0011a\u0001=%a!Q!\u0011 BY#\u0003%\tA!\u0016\u0002!\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\u0002\u0004B\u0003B\u007f\u0005c\u000b\n\u0011\"\u0005\u0003V\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002\u0004BCB\u0001\u0005c\u000b\t\u0011\"\u0003\u0004\u0004\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019)\u0001E\u0002M\u0007\u000fI1a!\u0003N\u0005\u0019y%M[3di\u0002")
public class CsvRelation
extends BaseRelation
implements TableScan,
InsertableRelation,
Product,
Serializable {
    private final String location;
    private final boolean useHeader;
    private final char delimiter;
    private final char quote;
    private final Character escape;
    private final String parseMode;
    private final String parserLib;
    private final boolean ignoreLeadingWhiteSpace;
    private final boolean ignoreTrailingWhiteSpace;
    private final StructType userSchema;
    private final transient SQLContext sqlContext;
    private final Logger com$databricks$spark$csv$CsvRelation$$logger;
    private final boolean com$databricks$spark$csv$CsvRelation$$failFast;
    private final boolean com$databricks$spark$csv$CsvRelation$$dropMalformed;
    private final boolean com$databricks$spark$csv$CsvRelation$$permissive;
    private final StructType schema;
    private String firstLine;
    private volatile boolean bitmap$0;

    public static StructType apply$default$10() {
        return CsvRelation$.MODULE$.apply$default$10();
    }

    private String firstLine$lzycompute() {
        CsvRelation csvRelation = this;
        synchronized (csvRelation) {
            if (!this.bitmap$0) {
                this.firstLine = (String)this.sqlContext().sparkContext().textFile(this.location(), this.sqlContext().sparkContext().textFile$default$2()).first();
                this.bitmap$0 = true;
            }
            return this.firstLine;
        }
    }

    public String location() {
        return this.location;
    }

    public boolean useHeader() {
        return this.useHeader;
    }

    public char delimiter() {
        return this.delimiter;
    }

    public char quote() {
        return this.quote;
    }

    public Character escape() {
        return this.escape;
    }

    public String parseMode() {
        return this.parseMode;
    }

    public String parserLib() {
        return this.parserLib;
    }

    public boolean ignoreLeadingWhiteSpace() {
        return this.ignoreLeadingWhiteSpace;
    }

    public boolean ignoreTrailingWhiteSpace() {
        return this.ignoreTrailingWhiteSpace;
    }

    public StructType userSchema() {
        return this.userSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Logger com$databricks$spark$csv$CsvRelation$$logger() {
        return this.com$databricks$spark$csv$CsvRelation$$logger;
    }

    public boolean com$databricks$spark$csv$CsvRelation$$failFast() {
        return this.com$databricks$spark$csv$CsvRelation$$failFast;
    }

    public boolean com$databricks$spark$csv$CsvRelation$$dropMalformed() {
        return this.com$databricks$spark$csv$CsvRelation$$dropMalformed;
    }

    public boolean com$databricks$spark$csv$CsvRelation$$permissive() {
        return this.com$databricks$spark$csv$CsvRelation$$permissive;
    }

    public StructType schema() {
        return this.schema;
    }

    public RDD<Row> buildScan() {
        RDD rDD;
        RDD baseRDD = this.sqlContext().sparkContext().textFile(this.location(), this.sqlContext().sparkContext().textFile$default$2());
        String[] fieldNames = this.schema().fieldNames();
        if (ParserLibs$.MODULE$.isUnivocityLib(this.parserLib())) {
            rDD = this.univocityParseCSV((RDD<String>)baseRDD, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])this.schema().fields()));
        } else {
            CSVFormat csvFormat = CSVFormat.DEFAULT.withDelimiter(this.delimiter()).withQuote(this.quote()).withEscape(this.escape()).withSkipHeaderRecord(false).withHeader(fieldNames);
            String filterLine = this.useHeader() ? this.firstLine() : null;
            rDD = baseRDD.mapPartitions((Function1)new Serializable(this, csvFormat, filterLine){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CsvRelation $outer;
                private final CSVFormat csvFormat$1;
                public final String filterLine$2;

                public final Iterator<Row> apply(Iterator<String> iter) {
                    Iterator csvIter = this.$outer.useHeader() ? iter.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildScan$1 $outer;

                        public final boolean apply(String x$1) {
                            String string = x$1;
                            String string2 = this.$outer.filterLine$2;
                            return string != null ? !string.equals(string2) : string2 != null;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }) : iter;
                    return this.$outer.com$databricks$spark$csv$CsvRelation$$parseCSV((Iterator<String>)csvIter, this.csvFormat$1, (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.schema().fields()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.csvFormat$1 = csvFormat$1;
                    this.filterLine$2 = filterLine$2;
                }
            }, baseRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        }
        return rDD;
    }

    private StructType inferSchema() {
        StructType structType;
        if (this.userSchema() == null) {
            String[] stringArray;
            if (ParserLibs$.MODULE$.isUnivocityLib(this.parserLib())) {
                char escapeVal = this.escape() == null ? (char)'\\' : (char)this.escape().charValue();
                char x$14 = this.delimiter();
                char x$15 = this.quote();
                char x$16 = escapeVal;
                String x$17 = LineCsvReader$.MODULE$.$lessinit$greater$default$2();
                boolean x$18 = LineCsvReader$.MODULE$.$lessinit$greater$default$5();
                boolean x$19 = LineCsvReader$.MODULE$.$lessinit$greater$default$6();
                int x$20 = LineCsvReader$.MODULE$.$lessinit$greater$default$7();
                int x$21 = LineCsvReader$.MODULE$.$lessinit$greater$default$8();
                stringArray = new LineCsvReader(x$14, x$17, x$15, x$16, x$18, x$19, x$20, x$21).parseLine(this.firstLine());
            } else {
                CSVFormat csvFormat = CSVFormat.DEFAULT.withDelimiter(this.delimiter()).withQuote(this.quote()).withEscape(this.escape()).withSkipHeaderRecord(false);
                stringArray = (String[])JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)JavaConversions$.MODULE$.asScalaBuffer(CSVParser.parse((String)this.firstLine(), (CSVFormat)csvFormat).getRecords()).head()).toArray(ClassTag$.MODULE$.apply(String.class));
            }
            String[] firstRow = stringArray;
            String[] header = this.useHeader() ? firstRow : (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstRow).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int index = tuple2._2$mcI$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            StructField[] schemaFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fieldName) {
                    return new StructField(fieldName.toString(), (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            structType = new StructType(schemaFields);
        } else {
            structType = this.userSchema();
        }
        return structType;
    }

    private String firstLine() {
        return this.bitmap$0 ? this.firstLine : this.firstLine$lzycompute();
    }

    private RDD<Row> univocityParseCSV(RDD<String> file, Seq<String> header, Seq<StructField> schemaFields) {
        String filterLine = this.useHeader() ? this.firstLine() : null;
        RDD dataLines = this.useHeader() ? file.filter((Function1)new Serializable(this, filterLine){
            public static final long serialVersionUID = 0L;
            private final String filterLine$1;

            public final boolean apply(String x$2) {
                String string = x$2;
                String string2 = this.filterLine$1;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.filterLine$1 = filterLine$1;
            }
        }) : file;
        RDD rows = dataLines.mapPartitionsWithIndex((Function2)new Serializable(this, header, schemaFields){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CsvRelation $outer;
            private final Seq header$1;
            public final Seq schemaFields$1;

            public final Iterator<Row> apply(int x0$1, Iterator<String> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), x1$1);
                if (tuple2 != null) {
                    int split = tuple2._1$mcI$sp();
                    Iterator iter = (Iterator)tuple2._2();
                    char escapeVal = this.$outer.escape() == null ? (char)'\\' : (char)this.$outer.escape().charValue();
                    Iterator x$3 = iter;
                    int x$4 = split;
                    Seq x$5 = this.header$1;
                    char x$6 = this.$outer.delimiter();
                    char x$7 = this.$outer.quote();
                    char x$8 = escapeVal;
                    String x$9 = BulkCsvReader$.MODULE$.$lessinit$greater$default$4();
                    boolean x$10 = BulkCsvReader$.MODULE$.$lessinit$greater$default$7();
                    boolean x$11 = BulkCsvReader$.MODULE$.$lessinit$greater$default$8();
                    int x$12 = BulkCsvReader$.MODULE$.$lessinit$greater$default$10();
                    int x$13 = BulkCsvReader$.MODULE$.$lessinit$greater$default$11();
                    Iterator<B> iterator = new BulkCsvReader((Iterator<String>)x$3, x$4, x$6, x$9, x$7, x$8, x$10, x$11, (Seq<String>)x$5, x$12, x$13).flatMap(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;

                        public final Iterable<Row> apply(String[] tokens) {
                            Iterable iterable;
                            block8: {
                                block7: {
                                    if (!this.$outer.com$databricks$spark$csv$CsvRelation$$anonfun$$$outer().com$databricks$spark$csv$CsvRelation$$dropMalformed() || this.$outer.schemaFields$1.length() == Predef$.MODULE$.refArrayOps((Object[])tokens).size()) break block7;
                                    this.$outer.com$databricks$spark$csv$CsvRelation$$anonfun$$$outer().com$databricks$spark$csv$CsvRelation$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping malformed line: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokens})));
                                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                    break block8;
                                }
                                if (this.$outer.com$databricks$spark$csv$CsvRelation$$anonfun$$$outer().com$databricks$spark$csv$CsvRelation$$failFast() && this.$outer.schemaFields$1.length() != Predef$.MODULE$.refArrayOps((Object[])tokens).size()) {
                                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed line in FAILFAST mode: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokens})));
                                }
                                int index = 0;
                                Object[] rowArray = new Object[this.$outer.schemaFields$1.length()];
                                try {
                                    for (index = 0; index < this.$outer.schemaFields$1.length(); ++index) {
                                        rowArray[index] = TypeCast$.MODULE$.castTo(tokens[index], ((StructField)this.$outer.schemaFields$1.apply(index)).dataType());
                                    }
                                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)rowArray))));
                                }
                                catch (Throwable throwable) {
                                    Iterable iterable2;
                                    block10: {
                                        Throwable e;
                                        block12: {
                                            block11: {
                                                Throwable throwable2;
                                                block9: {
                                                    throwable2 = throwable;
                                                    if (!(throwable2 instanceof ArrayIndexOutOfBoundsException) || !this.$outer.com$databricks$spark$csv$CsvRelation$$anonfun$$$outer().com$databricks$spark$csv$CsvRelation$$permissive()) break block9;
                                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(index), this.$outer.schemaFields$1.length()).foreach$mVc$sp((Function1)new Serializable(this, rowArray){
                                                        public static final long serialVersionUID = 0L;
                                                        private final Object[] rowArray$1;

                                                        public final void apply(int ind) {
                                                            this.apply$mcVI$sp(ind);
                                                        }

                                                        public void apply$mcVI$sp(int ind) {
                                                            this.rowArray$1[ind] = null;
                                                        }
                                                        {
                                                            this.rowArray$1 = rowArray$1;
                                                        }
                                                    });
                                                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)rowArray))));
                                                    break block10;
                                                }
                                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                                if (option.isEmpty()) break block11;
                                                e = (Throwable)option.get();
                                                if (!this.$outer.com$databricks$spark$csv$CsvRelation$$anonfun$$$outer().com$databricks$spark$csv$CsvRelation$$failFast()) break block12;
                                            }
                                            throw throwable;
                                        }
                                        this.$outer.com$databricks$spark$csv$CsvRelation$$anonfun$$$outer().com$databricks$spark$csv$CsvRelation$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while parsing line: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokens})), e);
                                        iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                    }
                                    iterable = iterable2;
                                }
                            }
                            return iterable;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return iterator;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ CsvRelation com$databricks$spark$csv$CsvRelation$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.header$1 = header$1;
                this.schemaFields$1 = schemaFields$1;
            }
        }, true, ClassTag$.MODULE$.apply(Row.class));
        return rows;
    }

    public Iterator<Row> com$databricks$spark$csv$CsvRelation$$parseCSV(Iterator<String> iter, CSVFormat csvFormat, Seq<StructField> schemaFields) {
        return iter.flatMap((Function1)new Serializable(this, csvFormat, schemaFields){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CsvRelation $outer;
            private final CSVFormat csvFormat$2;
            private final Seq schemaFields$2;

            public final GenTraversableOnce<Row> apply(String line) {
                Iterable iterable;
                int index = 0;
                Object[] rowArray = new Object[this.schemaFields$2.length()];
                try {
                    List records = CSVParser.parse((String)line, (CSVFormat)this.csvFormat$2).getRecords();
                    if (records.isEmpty()) {
                        this.$outer.com$databricks$spark$csv$CsvRelation$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring empty line: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})));
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    } else {
                        CSVRecord tokens = (CSVRecord)JavaConversions$.MODULE$.asScalaBuffer(records).head();
                        if (this.$outer.com$databricks$spark$csv$CsvRelation$$dropMalformed() && this.schemaFields$2.length() != tokens.size()) {
                            this.$outer.com$databricks$spark$csv$CsvRelation$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping malformed line: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})));
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        } else {
                            if (this.$outer.com$databricks$spark$csv$CsvRelation$$failFast() && this.schemaFields$2.length() != tokens.size()) {
                                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed line in FAILFAST mode: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})));
                            }
                            for (index = 0; index < this.schemaFields$2.length(); ++index) {
                                rowArray[index] = TypeCast$.MODULE$.castTo(tokens.get(index), ((StructField)this.schemaFields$2.apply(index)).dataType());
                            }
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)rowArray))));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    block12: {
                        Throwable e;
                        block14: {
                            block13: {
                                Throwable throwable2;
                                block11: {
                                    throwable2 = throwable;
                                    if (!(throwable2 instanceof ArrayIndexOutOfBoundsException) || !this.$outer.com$databricks$spark$csv$CsvRelation$$permissive()) break block11;
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(index), this.schemaFields$2.length()).foreach$mVc$sp((Function1)new Serializable(this, rowArray){
                                        public static final long serialVersionUID = 0L;
                                        private final Object[] rowArray$2;

                                        public final void apply(int ind) {
                                            this.apply$mcVI$sp(ind);
                                        }

                                        public void apply$mcVI$sp(int ind) {
                                            this.rowArray$2[ind] = null;
                                        }
                                        {
                                            this.rowArray$2 = rowArray$2;
                                        }
                                    });
                                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)rowArray))));
                                    break block12;
                                }
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (option.isEmpty()) break block13;
                                e = (Throwable)option.get();
                                if (!this.$outer.com$databricks$spark$csv$CsvRelation$$failFast()) break block14;
                            }
                            throw throwable;
                        }
                        this.$outer.com$databricks$spark$csv$CsvRelation$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while parsing line: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), e);
                        iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    iterable = iterable2;
                }
                return iterable;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.csvFormat$2 = csvFormat$2;
                this.schemaFields$2 = schemaFields$2;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(DataFrame data, boolean overwrite) {
        Path filesystemPath = new Path(this.location());
        FileSystem fs = filesystemPath.getFileSystem(this.sqlContext().sparkContext().hadoopConfiguration());
        if (!overwrite) throw scala.sys.package$.MODULE$.error("CSV tables only support INSERT OVERWRITE for now.");
        try {
            fs.delete(filesystemPath, true);
        }
        catch (IOException iOException) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to clear output directory ", " prior"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filesystemPath.toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to INSERT OVERWRITE a CSV table:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.toString()}))).toString());
        }
        package.CsvSchemaRDD qual$1 = package$.MODULE$.CsvSchemaRDD(data);
        String x$22 = this.location();
        Map x$23 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"delimiter"), (Object)((Object)BoxesRunTime.boxToCharacter((char)this.delimiter())).toString())}));
        Class<? extends CompressionCodec> x$24 = qual$1.saveAsCsvFile$default$3();
        qual$1.saveAsCsvFile(x$22, (Map<String, String>)x$23, x$24);
    }

    public CsvRelation copy(String location, boolean useHeader, char delimiter, char quote, Character escape, String parseMode, String parserLib, boolean ignoreLeadingWhiteSpace, boolean ignoreTrailingWhiteSpace, StructType userSchema, SQLContext sqlContext) {
        return new CsvRelation(location, useHeader, delimiter, quote, escape, parseMode, parserLib, ignoreLeadingWhiteSpace, ignoreTrailingWhiteSpace, userSchema, sqlContext);
    }

    public String copy$default$1() {
        return this.location();
    }

    public boolean copy$default$2() {
        return this.useHeader();
    }

    public char copy$default$3() {
        return this.delimiter();
    }

    public char copy$default$4() {
        return this.quote();
    }

    public Character copy$default$5() {
        return this.escape();
    }

    public String copy$default$6() {
        return this.parseMode();
    }

    public String copy$default$7() {
        return this.parserLib();
    }

    public boolean copy$default$8() {
        return this.ignoreLeadingWhiteSpace();
    }

    public boolean copy$default$9() {
        return this.ignoreTrailingWhiteSpace();
    }

    public StructType copy$default$10() {
        return this.userSchema();
    }

    public String productPrefix() {
        return "CsvRelation";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 9: {
                object = this.userSchema();
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreTrailingWhiteSpace());
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreLeadingWhiteSpace());
                break;
            }
            case 6: {
                object = this.parserLib();
                break;
            }
            case 5: {
                object = this.parseMode();
                break;
            }
            case 4: {
                object = this.escape();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToCharacter((char)this.quote());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToCharacter((char)this.delimiter());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useHeader());
                break;
            }
            case 0: {
                object = this.location();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvRelation;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.location()));
        n = Statics.mix((int)n, (int)(this.useHeader() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.delimiter());
        n = Statics.mix((int)n, (int)this.quote());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.escape()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parseMode()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parserLib()));
        n = Statics.mix((int)n, (int)(this.ignoreLeadingWhiteSpace() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.ignoreTrailingWhiteSpace() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userSchema()));
        return Statics.finalizeHash((int)n, (int)10);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvRelation csvRelation = (CsvRelation)((Object)x$1);
        String string = this.location();
        String string2 = csvRelation.location();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.useHeader() != csvRelation.useHeader()) return false;
        if (this.delimiter() != csvRelation.delimiter()) return false;
        if (this.quote() != csvRelation.quote()) return false;
        Character c = this.escape();
        Character c2 = csvRelation.escape();
        if (c == null) {
            if (c2 != null) {
                return false;
            }
        } else if (!((Object)c).equals(c2)) return false;
        String string3 = this.parseMode();
        String string4 = csvRelation.parseMode();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.parserLib();
        String string6 = csvRelation.parserLib();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        if (this.ignoreLeadingWhiteSpace() != csvRelation.ignoreLeadingWhiteSpace()) return false;
        if (this.ignoreTrailingWhiteSpace() != csvRelation.ignoreTrailingWhiteSpace()) return false;
        StructType structType = this.userSchema();
        StructType structType2 = csvRelation.userSchema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        if (!csvRelation.canEqual((Object)this)) return false;
        return true;
    }

    public CsvRelation(String location, boolean useHeader, char delimiter, char quote, Character escape, String parseMode, String parserLib, boolean ignoreLeadingWhiteSpace, boolean ignoreTrailingWhiteSpace, StructType userSchema, SQLContext sqlContext) {
        this.location = location;
        this.useHeader = useHeader;
        this.delimiter = delimiter;
        this.quote = quote;
        this.escape = escape;
        this.parseMode = parseMode;
        this.parserLib = parserLib;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreTrailingWhiteSpace = ignoreTrailingWhiteSpace;
        this.userSchema = userSchema;
        this.sqlContext = sqlContext;
        Product.class.$init$((Product)this);
        this.com$databricks$spark$csv$CsvRelation$$logger = LoggerFactory.getLogger(CsvRelation$.MODULE$.getClass());
        if (!ParseModes$.MODULE$.isValidMode(parseMode)) {
            this.com$databricks$spark$csv$CsvRelation$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a valid parse mode. Using ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parseMode, ParseModes$.MODULE$.DEFAULT()})));
        }
        if ((ignoreLeadingWhiteSpace || ignoreLeadingWhiteSpace) && ParserLibs$.MODULE$.isCommonsLib(parserLib)) {
            this.com$databricks$spark$csv$CsvRelation$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore white space options may not work with Commons parserLib option"})).s((Seq)Nil$.MODULE$));
        }
        this.com$databricks$spark$csv$CsvRelation$$failFast = ParseModes$.MODULE$.isFailFastMode(parseMode);
        this.com$databricks$spark$csv$CsvRelation$$dropMalformed = ParseModes$.MODULE$.isDropMalformedMode(parseMode);
        this.com$databricks$spark$csv$CsvRelation$$permissive = ParseModes$.MODULE$.isPermissiveMode(parseMode);
        this.schema = this.inferSchema();
    }
}

