/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;

public final class FilterPushdown$ {
    public static final FilterPushdown$ MODULE$;

    static {
        new FilterPushdown$();
    }

    public String buildWhereClause(StructType schema2, Seq<Filter> filters) {
        String filterExpressions = ((TraversableOnce)filters.flatMap((Function1)new Serializable(schema2){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Iterable<String> apply(Filter f) {
                return Option$.MODULE$.option2Iterable(FilterPushdown$.MODULE$.buildFilterExpression(this.schema$1, f));
            }
            {
                this.schema$1 = schema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        return filterExpressions.isEmpty() ? "" : new StringBuilder().append((Object)"WHERE ").append((Object)filterExpressions).toString();
    }

    public Option<String> buildFilterExpression(StructType schema2, Filter filter) {
        Option option;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            option = this.buildComparison$1(attr, value, "=", schema2);
        } else if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            option = this.buildComparison$1(attr, value, "<", schema2);
        } else if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            option = this.buildComparison$1(attr, value, ">", schema2);
        } else if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            option = this.buildComparison$1(attr, value, "<=", schema2);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            option = this.buildComparison$1(attr, value, ">=", schema2);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            option = this.getTypeForAttribute(schema2, attr).map((Function1)new Serializable(attr){
                public static final long serialVersionUID = 0L;
                private final String attr$2;

                public final String apply(DataType dataType) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\" IS NOT NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attr$2}));
                }
                {
                    this.attr$2 = attr$2;
                }
            });
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            option = this.getTypeForAttribute(schema2, attr).map((Function1)new Serializable(attr){
                public static final long serialVersionUID = 0L;
                private final String attr$3;

                public final String apply(DataType dataType) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\" IS NULL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attr$3}));
                }
                {
                    this.attr$3 = attr$3;
                }
            });
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private Option<DataType> getTypeForAttribute(StructType schema2, String attribute) {
        return Predef$.MODULE$.refArrayOps((Object[])schema2.fieldNames()).contains((Object)attribute) ? new Some((Object)schema2.apply(attribute).dataType()) : None$.MODULE$;
    }

    private final Option buildComparison$1(String attr, Object value, String comparisonOp, StructType schema$2) {
        return this.getTypeForAttribute(schema$2, attr).map((Function1)new Serializable(attr, value, comparisonOp){
            public static final long serialVersionUID = 0L;
            private final String attr$1;
            private final Object value$1;
            private final String comparisonOp$1;

            public final String apply(DataType dataType) {
                String string;
                DataType dataType2 = dataType;
                StringType$ stringType$ = StringType$.MODULE$;
                DataType dataType3 = dataType2;
                if (!(stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\'", "\\\\'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1.toString().replace("'", "\\'\\'")}));
                } else {
                    DateType$ dateType$ = DateType$.MODULE$;
                    DataType dataType4 = dataType2;
                    if (!(dateType$ != null ? !dateType$.equals(dataType4) : dataType4 != null)) {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\'", "\\\\'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Date)this.value$1}));
                    } else {
                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                        DataType dataType5 = dataType2;
                        string = !(timestampType$ != null ? !timestampType$.equals(dataType5) : dataType5 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\'", "\\\\'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Timestamp)this.value$1})) : this.value$1.toString();
                    }
                }
                String sqlEscapedValue = string;
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\" ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attr$1, this.comparisonOp$1, sqlEscapedValue}));
            }
            {
                this.attr$1 = attr$1;
                this.value$1 = value$1;
                this.comparisonOp$1 = comparisonOp$1;
            }
        });
    }

    private FilterPushdown$() {
        MODULE$ = this;
    }
}

