/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final Logger log;

    static {
        new Utils$();
    }

    private Logger log() {
        return this.log;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ClassLoader apply() {
                return Utils$.MODULE$.getClass().getClassLoader();
            }
        });
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(a)).stripSuffix("/")).append((Object)"/").append((Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(b)).stripPrefix("/"))).stripSuffix("/")).append((Object)"/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String makeTempPath(String tempRoot) {
        return this.joinUrls(tempRoot, UUID.randomUUID().toString());
    }

    public void checkThatBucketHasObjectLifecycleConfiguration(String tempDir, AmazonS3Client s3Client) {
        try {
            AmazonS3URI s3URI = new AmazonS3URI(this.fixS3Url(tempDir));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not get bucket from S3 URI";
                }
            });
            String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            Seq rules = (Seq)Option$.MODULE$.apply((Object)s3Client.getBucketLifecycleConfiguration(bucket)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Buffer<BucketLifecycleConfiguration.Rule> apply(BucketLifecycleConfiguration x$1) {
                    return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getRules()).asScala();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            });
            boolean hasMatchingBucketLifecycleRule = rules.exists((Function1)new Serializable(key){
                public static final long serialVersionUID = 0L;
                private final String key$1;

                public final boolean apply(BucketLifecycleConfiguration.Rule rule) {
                    String string = rule.getStatus();
                    String string2 = "Enabled";
                    return !(string != null ? !string.equals(string2) : string2 != null) && this.key$1.startsWith(rule.getPrefix());
                }
                {
                    this.key$1 = key$1;
                }
            });
            if (!hasMatchingBucketLifecycleRule) {
                this.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The S3 bucket ", " does not have an object lifecycle configuration to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket}))).append((Object)"ensure cleanup of temporary files. Consider configuring `tempdir` to point to a ").append((Object)"bucket with an object lifecycle policy that automatically deletes files after an ").append((Object)"expiration period. For more information, see ").append((Object)"https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration", e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void assertThatFileSystemIsNotS3BlockFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-redshift does not support the S3 Block FileSystem. Please reconfigure `tempdir` touse a s3n:// or s3a:// scheme.");
        }
    }

    private Utils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

