/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.databricks.spark.redshift.Parameters;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;

public final class AWSCredentialsUtils$ {
    public static final AWSCredentialsUtils$ MODULE$;

    static {
        new AWSCredentialsUtils$();
    }

    public String getRedshiftCredentialsString(Parameters.MergedParameters params, AWSCredentials sparkAwsCredentials) {
        block5: {
            String string;
            block3: {
                block4: {
                    block2: {
                        if (!params.iamRole().isDefined()) break block2;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_iam_role=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.iamRole().get()}));
                        break block3;
                    }
                    if (!params.temporaryAWSCredentials().isDefined()) break block4;
                    string = this.awsCredsToString$1(((AWSCredentialsProvider)params.temporaryAWSCredentials().get()).getCredentials());
                    break block3;
                }
                if (!params.forwardSparkS3Credentials()) break block5;
                string = this.awsCredsToString$1(sparkAwsCredentials);
            }
            return string;
        }
        throw new IllegalStateException("No Redshift S3 authentication mechanism was specified");
    }

    public AWSCredentialsProvider staticCredentialsProvider(AWSCredentials credentials2) {
        return new AWSCredentialsProvider(credentials2){
            private final AWSCredentials credentials$1;

            public AWSCredentials getCredentials() {
                return this.credentials$1;
            }

            public void refresh() {
            }
            {
                this.credentials$1 = credentials$1;
            }
        };
    }

    public AWSCredentialsProvider load(Parameters.MergedParameters params, Configuration hadoopConfiguration) {
        return (AWSCredentialsProvider)params.temporaryAWSCredentials().getOrElse((Function0)new Serializable(params, hadoopConfiguration){
            public static final long serialVersionUID = 0L;
            private final Parameters.MergedParameters params$1;
            private final Configuration hadoopConfiguration$1;

            public final AWSCredentialsProvider apply() {
                return AWSCredentialsUtils$.MODULE$.com$databricks$spark$redshift$AWSCredentialsUtils$$loadFromURI(this.params$1.rootTempDir(), this.hadoopConfiguration$1);
            }
            {
                this.params$1 = params$1;
                this.hadoopConfiguration$1 = hadoopConfiguration$1;
            }
        });
    }

    public AWSCredentialsProvider com$databricks$spark$redshift$AWSCredentialsUtils$$loadFromURI(String tempPath, Configuration hadoopConfiguration) {
        URI uri = new URI(tempPath);
        String uriScheme = uri.getScheme();
        String string = uriScheme;
        boolean bl = "s3".equals(string) ? true : ("s3n".equals(string) ? true : "s3a".equals(string));
        if (bl) {
            AWSCredentialsProvider aWSCredentialsProvider = (AWSCredentialsProvider)Option$.MODULE$.apply((Object)uri.getUserInfo()).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Option<AWSCredentialsProvider> apply(String userInfo) {
                    None$ none$;
                    if (userInfo.contains(":")) {
                        Tuple2 tuple2;
                        String[] stringArray = userInfo.split(":");
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)stringArray);
                        String accessKey = (String)((SeqLike)option.get()).apply(0);
                        String secretKey = (String)((SeqLike)option.get()).apply(1);
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
                        String accessKey2 = (String)tuple22._1();
                        String secretKey2 = (String)tuple22._2();
                        none$ = new Some((Object)AWSCredentialsUtils$.MODULE$.staticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey2, secretKey2)));
                        return none$;
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }
            }).orElse((Function0)new Serializable(hadoopConfiguration, uriScheme){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConfiguration$2;
                private final String uriScheme$1;

                public final Option<AWSCredentialsProvider> apply() {
                    String string = this.uriScheme$1;
                    String string2 = "s3a";
                    String accessKeyConfig = !(string != null ? !string.equals(string2) : string2 != null) ? "access.key" : "awsAccessKeyId";
                    String string3 = this.uriScheme$1;
                    String string4 = "s3a";
                    String secretKeyConfig = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "secret.key" : "awsSecretAccessKey";
                    String accessKey = this.hadoopConfiguration$2.get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fs.", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uriScheme$1, accessKeyConfig})), null);
                    String secretKey = this.hadoopConfiguration$2.get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fs.", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uriScheme$1, secretKeyConfig})), null);
                    return accessKey == null || secretKey == null ? None$.MODULE$ : new Some((Object)AWSCredentialsUtils$.MODULE$.staticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)));
                }
                {
                    this.hadoopConfiguration$2 = hadoopConfiguration$2;
                    this.uriScheme$1 = uriScheme$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DefaultAWSCredentialsProviderChain apply() {
                    return new DefaultAWSCredentialsProviderChain();
                }
            });
            return aWSCredentialsProvider;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized scheme ", "; expected s3, s3n, or s3a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private final String awsCredsToString$1(AWSCredentials credentials2) {
        String string;
        AWSCredentials aWSCredentials = credentials2;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_access_key_id=", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSSessionCredentials.getAWSAccessKeyId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_secret_access_key=", ";token=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSSessionCredentials.getAWSSecretKey(), aWSSessionCredentials.getSessionToken()}))).toString();
        } else {
            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_access_key_id=", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSCredentials.getAWSAccessKeyId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_secret_access_key=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSCredentials.getAWSSecretKey()}))).toString();
        }
        return string;
    }

    private AWSCredentialsUtils$() {
        MODULE$ = this;
    }
}

