/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.databricks.spark.redshift.Utils$;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.package$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\u0001\u0003\u0001\tQ!a\u0003&E\u0005\u000e;&/\u00199qKJT!a\u0001\u0003\u0002\u0011I,Gm\u001d5jMRT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011A\u00033bi\u0006\u0014'/[2lg*\t\u0011\"A\u0002d_6\u001c\"\u0001A\u0006\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0011\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00053\u0005\u0019An\\4\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000bMdg\r\u000e6\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0004M_\u001e<WM\u001d\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000e\u0002\t1|w\r\t\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003\t)7-F\u0001(!\tA3&D\u0001*\u0015\tQS\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0015\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bB\u0002\u0018\u0001A\u0003%q%A\u0002fG\u0002BQ\u0001\r\u0001\u0005\nE\nabZ3u\tJLg/\u001a:DY\u0006\u001c8\u000fF\u00023sm\u0002\"a\r\u001c\u000f\u00051!\u0014BA\u001b\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Uj\u0001\"\u0002\u001e0\u0001\u0004\u0011\u0014a\u00046eE\u000e\u001cVO\u00199s_R|7m\u001c7\t\u000bqz\u0003\u0019A\u001f\u0002/U\u001cXM\u001d)s_ZLG-\u001a3Ee&4XM]\"mCN\u001c\bc\u0001\u0007?e%\u0011q(\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\u0005\u0003A\u0011\u0001\"\u0002)\u0015DXmY;uK&sG/\u001a:skB$\u0018N\u00197z)\t\u0019e\t\u0005\u0002\r\t&\u0011Q)\u0004\u0002\b\u0005>|G.Z1o\u0011\u00159\u0005\t1\u0001I\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u00191/\u001d7\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\b\"B)\u0001\t\u0003\u0011\u0016!G3yK\u000e,H/Z)vKJL\u0018J\u001c;feJ,\b\u000f^5cYf$\"a\u0015,\u0011\u0005%#\u0016BA+K\u0005%\u0011Vm];miN+G\u000fC\u0003H!\u0002\u0007\u0001\nC\u0003B\u0001\u0011%\u0001,\u0006\u0002Z9R\u0019!,\u001a4\u0011\u0005mcF\u0002\u0001\u0003\u0006;^\u0013\rA\u0018\u0002\u0002)F\u0011qL\u0019\t\u0003\u0019\u0001L!!Y\u0007\u0003\u000f9{G\u000f[5oOB\u0011AbY\u0005\u0003I6\u00111!\u00118z\u0011\u00159u\u000b1\u0001I\u0011\u00159w\u000b1\u0001i\u0003\ty\u0007\u000f\u0005\u0003\rS\"S\u0016B\u00016\u000e\u0005%1UO\\2uS>t\u0017\u0007C\u0003m\u0001\u0011\u0005Q.\u0001\u0007sKN|GN^3UC\ndW\rF\u0002oqv\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\u000bQL\b/Z:\u000b\u0005-\u001b(BA\u0003u\u0015\t)h$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003oB\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015I8\u000e1\u0001{\u0003\u0011\u0019wN\u001c8\u0011\u0005%[\u0018B\u0001?K\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\u0006}.\u0004\rAM\u0001\u0006i\u0006\u0014G.\u001a\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u000319W\r^\"p]:,7\r^8s)\u001dQ\u0018QAA\u0004\u0003\u0017AQ\u0001P@A\u0002uBa!!\u0003\u0000\u0001\u0004\u0011\u0014aA;sY\"9\u0011QB@A\u0002\u0005=\u0011aC2sK\u0012,g\u000e^5bYN\u0004B\u0001\u0004 \u0002\u0012A)A\"a\u00053e%\u0019\u0011QC\u0007\u0003\rQ+\b\u000f\\33\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tAb]2iK6\f7\u000b\u001e:j]\u001e$2AMA\u000f\u0011\u001d\ty\"a\u0006A\u00029\faa]2iK6\f\u0007bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\fi\u0006\u0014G.Z#ySN$8\u000fF\u0003D\u0003O\tI\u0003\u0003\u0004z\u0003C\u0001\rA\u001f\u0005\u0007}\u0006\u0005\u0002\u0019\u0001\u001a\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u0005yq-\u001a;DCR\fG._:u)f\u0004X\r\u0006\u0006\u00022\u0005]\u0012\u0011IA#\u0003\u0013\u00022a\\A\u001a\u0013\r\t)\u0004\u001d\u0002\t\t\u0006$\u0018\rV=qK\"A\u0011\u0011HA\u0016\u0001\u0004\tY$A\u0004tc2$\u0016\u0010]3\u0011\u00071\ti$C\u0002\u0002@5\u00111!\u00138u\u0011!\t\u0019%a\u000bA\u0002\u0005m\u0012!\u00039sK\u000eL7/[8o\u0011!\t9%a\u000bA\u0002\u0005m\u0012!B:dC2,\u0007bBA&\u0003W\u0001\raQ\u0001\u0007g&<g.\u001a3")
public class JDBCWrapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutionContext ec;

    private Logger log() {
        return this.log;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    private String getDriverClass(String jdbcSubprotocol, Option<String> userProvidedDriverClass) {
        return (String)userProvidedDriverClass.getOrElse((Function0)new Serializable(this, jdbcSubprotocol){
            public static final long serialVersionUID = 0L;
            private final String jdbcSubprotocol$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final String apply() {
                String string = this.jdbcSubprotocol$1;
                if ("redshift".equals(string)) {
                    String string2;
                    try {
                        string2 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc42.Driver").getName();
                        return string2;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            string2 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc41.Driver").getName();
                            return string2;
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            try {
                                string2 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc4.Driver").getName();
                                return string2;
                            }
                            catch (ClassNotFoundException classNotFoundException3) {
                                throw new ClassNotFoundException("Could not load an Amazon Redshift JDBC driver; see the README for instructions on downloading and configuring the official Amazon driver.", classNotFoundException3);
                            }
                        }
                    }
                } else {
                    if (!"postgresql".equals(string)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported JDBC protocol: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                    return "org.postgresql.Driver";
                }
            }
            {
                this.jdbcSubprotocol$1 = jdbcSubprotocol$1;
            }
        });
    }

    public boolean executeInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PreparedStatement x$1) {
                return x$1.execute();
            }
        }));
    }

    public ResultSet executeQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ResultSet apply(PreparedStatement x$2) {
                return x$2.executeQuery();
            }
        });
    }

    private <T> T executeInterruptibly(PreparedStatement statement, Function1<PreparedStatement, T> op) {
        try {
            Future future = Future$.MODULE$.apply((Function0)new Serializable(this, statement, op){
                public static final long serialVersionUID = 0L;
                private final PreparedStatement statement$1;
                private final Function1 op$1;

                public final T apply() {
                    return (T)this.op$1.apply((Object)this.statement$1);
                }
                {
                    this.statement$1 = statement$1;
                    this.op$1 = op$1;
                }
            }, this.ec());
            return (T)Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        }
        catch (InterruptedException interruptedException) {
            try {
                statement.cancel();
                throw interruptedException;
            }
            catch (SQLException sQLException) {
                this.log().error("Exception occurred while cancelling query", (Throwable)sQLException);
                throw interruptedException;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public StructType resolveTable(Connection conn, String table2) {
        StructType structType;
        ResultSet rs = this.executeQueryInterruptibly(conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", " WHERE 1=0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2}))));
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int ncols = rsmd.getColumnCount();
            StructField[] fields = new StructField[ncols];
            for (int i = 0; i < ncols; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                int dataType = rsmd.getColumnType(i + 1);
                int fieldSize = rsmd.getPrecision(i + 1);
                int fieldScale = rsmd.getScale(i + 1);
                boolean isSigned = rsmd.isSigned(i + 1);
                boolean nullable = rsmd.isNullable(i + 1) != 0;
                DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned);
                fields[i] = new StructField(columnName, columnType, nullable, StructField$.MODULE$.apply$default$4());
            }
            structType = new StructType(fields);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        rs.close();
        return structType;
    }

    public Connection getConnector(Option<String> userProvidedDriverClass, String url, Option<Tuple2<String, String>> credentials2) {
        String subprotocol = new StringOps(Predef$.MODULE$.augmentString(url)).stripPrefix("jdbc:").split(":")[0];
        String driverClass = this.getDriverClass(subprotocol, userProvidedDriverClass);
        DriverRegistry$.MODULE$.register(driverClass);
        Class<?> driverWrapperClass = package$.MODULE$.SPARK_VERSION().startsWith("1.4") ? Utils$.MODULE$.classForName("org.apache.spark.sql.jdbc.package$DriverWrapper") : Utils$.MODULE$.classForName("org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper");
        Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new Serializable(this, driverClass, driverWrapperClass){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCWrapper $outer;
            private final String driverClass$1;
            private final Class driverWrapperClass$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var5_8;
                A1 A1 = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(A1.getClass())) {
                    String string = this.$outer.com$databricks$spark$redshift$JDBCWrapper$$getWrapped$1(A1, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        A1 A12 = A1;
                        return var5_8;
                    }
                }
                String string = A1.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    A1 A13 = A1;
                    return var5_8;
                }
                Object object = function1.apply(x1);
                return var5_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Driver x1) {
                Driver driver = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(driver.getClass())) {
                    String string = this.$outer.com$databricks$spark$redshift$JDBCWrapper$$getWrapped$1(driver, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                String string = driver.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverClass$1 = driverClass$1;
                this.driverWrapperClass$1 = driverWrapperClass$1;
            }
        }).getOrElse((Function0)new Serializable(this, driverClass){
            public static final long serialVersionUID = 0L;
            private final String driverClass$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not find registered driver with class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.driverClass$1})));
            }
            {
                this.driverClass$1 = driverClass$1;
            }
        });
        Properties properties = new Properties();
        credentials2.foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String user = (String)tuple2._1();
                    String password = (String)tuple2._2();
                    this.properties$1.setProperty("user", user);
                    Object object = this.properties$1.setProperty("password", password);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        return driver.connect(url, properties);
    }

    public String schemaString(StructType schema2) {
        StringBuilder sb = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).foreach((Function1)new Serializable(this, sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final StringBuilder apply(StructField field) {
                block15: {
                    String string;
                    String name;
                    block3: {
                        String string2;
                        block5: {
                            DataType dataType;
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block4: {
                                                                    block2: {
                                                                        name = field.name();
                                                                        if (!field.metadata().contains("redshift_type")) break block2;
                                                                        string = field.metadata().getString("redshift_type");
                                                                        break block3;
                                                                    }
                                                                    dataType = field.dataType();
                                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block4;
                                                                    string2 = "INTEGER";
                                                                    break block5;
                                                                }
                                                                if (!LongType$.MODULE$.equals(dataType)) break block6;
                                                                string2 = "BIGINT";
                                                                break block5;
                                                            }
                                                            if (!DoubleType$.MODULE$.equals(dataType)) break block7;
                                                            string2 = "DOUBLE PRECISION";
                                                            break block5;
                                                        }
                                                        if (!FloatType$.MODULE$.equals(dataType)) break block8;
                                                        string2 = "REAL";
                                                        break block5;
                                                    }
                                                    if (!ShortType$.MODULE$.equals(dataType)) break block9;
                                                    string2 = "INTEGER";
                                                    break block5;
                                                }
                                                if (!ByteType$.MODULE$.equals(dataType)) break block10;
                                                string2 = "SMALLINT";
                                                break block5;
                                            }
                                            if (!BooleanType$.MODULE$.equals(dataType)) break block11;
                                            string2 = "BOOLEAN";
                                            break block5;
                                        }
                                        if (!StringType$.MODULE$.equals(dataType)) break block12;
                                        string2 = field.metadata().contains("maxlength") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VARCHAR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)field.metadata().getLong("maxlength"))})) : "TEXT";
                                        break block5;
                                    }
                                    if (!TimestampType$.MODULE$.equals(dataType)) break block13;
                                    string2 = "TIMESTAMP";
                                    break block5;
                                }
                                if (!DateType$.MODULE$.equals(dataType)) break block14;
                                string2 = "DATE";
                                break block5;
                            }
                            if (!(dataType instanceof DecimalType)) break block15;
                            DecimalType decimalType = (DecimalType)dataType;
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
                        }
                        string = string2;
                    }
                    String typ = string;
                    String nullable = field.nullable() ? "" : "NOT NULL";
                    String encoding = field.metadata().contains("encoding") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ENCODE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.metadata().getString("encoding")})) : "";
                    return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", \"", "\" ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name.replace("\"", "\\\""), typ, nullable, encoding})).trim());
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Don't know how to save ", " to JDBC"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})));
            }
            {
                this.sb$1 = sb$1;
            }
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public boolean tableExists(Connection conn, String table2) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, conn, table2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCWrapper $outer;
            private final Connection conn$1;
            private final String table$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.executeQueryInterruptibly(this.conn$1.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1})))).next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.table$1 = table$1;
            }
        }).isSuccess();
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        StringType$ answer;
        int n = sqlType;
        switch (n) {
            default: {
                StringType$ stringType$ = null;
                break;
            }
            case 12: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -3: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -6: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case 93: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 92: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 2002: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2009: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 5: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case -8: {
                StringType$ stringType$ = LongType$.MODULE$;
                break;
            }
            case 2006: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 7: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 1111: {
                StringType$ stringType$ = null;
                break;
            }
            case -9: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 0: {
                StringType$ stringType$ = null;
                break;
            }
            case 2011: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -16: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2000: {
                StringType$ stringType$ = null;
                break;
            }
            case 4: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 6: {
                StringType$ stringType$ = FloatType$.MODULE$;
                break;
            }
            case 8: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 2001: {
                StringType$ stringType$ = null;
                break;
            }
            case 3: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 91: {
                StringType$ stringType$ = DateType$.MODULE$;
                break;
            }
            case 70: {
                StringType$ stringType$ = null;
                break;
            }
            case 2005: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 16: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -2: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -5: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 2003: {
                StringType$ stringType$ = answer = null;
            }
        }
        if (answer == null) {
            throw new SQLException(new StringBuilder().append((Object)"Unsupported type ").append((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString());
        }
        return answer;
    }

    public final Driver com$databricks$spark$redshift$JDBCWrapper$$getWrapped$1(Driver d, Class driverWrapperClass$1) {
        Predef$.MODULE$.require(driverWrapperClass$1.isAssignableFrom(d.getClass()));
        return (Driver)driverWrapperClass$1.getDeclaredMethod("wrapped", new Class[0]).invoke((Object)d, new Object[0]);
    }

    public JDBCWrapper() {
        ThreadFactory threadFactory = new ThreadFactory(this){
            private final AtomicInteger count;

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r);
                thread.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-redshift-JDBCWrapper-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.count.incrementAndGet())})));
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.count = new AtomicInteger();
            }
        };
        this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
    }
}

