/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.databricks.spark.redshift.AWSCredentialsUtils$;
import com.databricks.spark.redshift.Conversions$;
import com.databricks.spark.redshift.JDBCWrapper;
import com.databricks.spark.redshift.Parameters;
import com.databricks.spark.redshift.RedshiftWriter$;
import com.databricks.spark.redshift.TableName;
import com.databricks.spark.redshift.Utils$;
import java.net.URI;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Accumulable;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0001\tQ!A\u0004*fIND\u0017N\u001a;Xe&$XM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3eg\"Lg\r\u001e\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u0001\n\u0003\r\u0019w.\\\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0017)$'mY,sCB\u0004XM]\u0002\u0001!\t)b#D\u0001\u0003\u0013\t9\"AA\u0006K\t\n\u001buK]1qa\u0016\u0014\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u001fM\u001c4\t\\5f]R4\u0015m\u0019;pef\u0004B\u0001D\u000e\u001eK%\u0011A$\u0004\u0002\n\rVt7\r^5p]F\u0002\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t\u0005,H\u000f\u001b\u0006\u0003E!\t\u0011\"Y7bu>t\u0017m^:\n\u0005\u0011z\"AF!X'\u000e\u0013X\rZ3oi&\fGn\u001d)s_ZLG-\u001a:\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AA:4\u0015\tQ\u0013%\u0001\u0005tKJ4\u0018nY3t\u0013\tasE\u0001\bB[\u0006TxN\\*4\u00072LWM\u001c;\t\u000b9\u0002A\u0011A\u0018\u0002\rqJg.\u001b;?)\r\u0001\u0014G\r\t\u0003+\u0001AQAE\u0017A\u0002QAQ!G\u0017A\u0002iAq\u0001\u000e\u0001C\u0002\u0013%Q'A\u0002m_\u001e,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nQa\u001d7gi)T\u0011aO\u0001\u0004_J<\u0017BA\u001f9\u0005\u0019aunZ4fe\"1q\b\u0001Q\u0001\nY\nA\u0001\\8hA!1\u0011\t\u0001C\u0001\u0005\t\u000bab\u0019:fCR,G+\u00192mKN\u000bH\u000eF\u0002D\u0015\u000e\u0004\"\u0001R$\u000f\u00051)\u0015B\u0001$\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019k\u0001\"B&A\u0001\u0004a\u0015\u0001\u00023bi\u0006\u0004\"!\u00141\u000f\u00059kfBA([\u001d\t\u0001\u0006L\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AkE\u0001\u0007yI|w\u000e\u001e \n\u0003mJ!a\u0016\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t)\u0011L\u0003\u0002Xu%\u00111\fX\u0001\u0004gFd'BA\u0003Z\u0013\tqv,A\u0004qC\u000e\\\u0017mZ3\u000b\u0005mc\u0016BA1c\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002_?\")A\r\u0011a\u0001K\u00061\u0001/\u0019:b[N\u0004\"AZ9\u000f\u0005\u001d|gB\u00015o\u001d\tIWN\u0004\u0002kY:\u0011!k[\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005A\u0014\u0011A\u0003)be\u0006lW\r^3sg&\u0011!o\u001d\u0002\u0011\u001b\u0016\u0014x-\u001a3QCJ\fW.\u001a;feNT!\u0001\u001d\u0002\t\u000bU\u0004A\u0011\u0002<\u0002\u000f\r|\u0007/_*rYR11i^?\u007f\u0003\u0003AQ\u0001\u001f;A\u0002e\f!b]9m\u0007>tG/\u001a=u!\tQ80D\u0001`\u0013\taxL\u0001\u0006T#2\u001buN\u001c;fqRDQ\u0001\u001a;A\u0002\u0015DQa ;A\u0002u\tQa\u0019:fINDa!a\u0001u\u0001\u0004\u0019\u0015aC7b]&4Wm\u001d;Ve2D\u0001\"a\u0002\u0001\t\u0003\u0011\u0011\u0011B\u0001\u000fG>lW.\u001a8u\u0003\u000e$\u0018n\u001c8t)\u0019\tY!a\u0007\u0002&A)\u0011QBA\u000b\u0007:!\u0011qBA\n\u001d\r\u0011\u0016\u0011C\u0005\u0002\u001d%\u0011a,D\u0005\u0005\u0003/\tIB\u0001\u0003MSN$(B\u00010\u000e\u0011!\ti\"!\u0002A\u0002\u0005}\u0011\u0001\u0004;bE2,7i\\7nK:$\b\u0003\u0002\u0007\u0002\"\rK1!a\t\u000e\u0005\u0019y\u0005\u000f^5p]\"A\u0011qEA\u0003\u0001\u0004\tI#\u0001\u0004tG\",W.\u0019\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF0\u0002\u000bQL\b/Z:\n\t\u0005M\u0012Q\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u001c\u0001\u0011%\u0011\u0011H\u0001\u000fI>\u0014V\rZ:iS\u001a$Hj\\1e)1\tY$!\u0011\u0002T\u0005U\u0013qKA-!\ra\u0011QH\u0005\u0004\u0003\u007fi!\u0001B+oSRD\u0001\"a\u0011\u00026\u0001\u0007\u0011QI\u0001\u0005G>tg\u000e\u0005\u0003\u0002H\u0005=SBAA%\u0015\rY\u00161\n\u0006\u0003\u0003\u001b\nAA[1wC&!\u0011\u0011KA%\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\u0007\u0017\u0006U\u0002\u0019\u0001'\t\r\u0011\f)\u00041\u0001f\u0011\u0019y\u0018Q\u0007a\u0001;!A\u00111AA\u001b\u0001\u0004\ty\u0002C\u0004\u0002^\u0001!I!a\u0018\u0002\u0015UtGn\\1e\t\u0006$\u0018\r\u0006\u0007\u0002 \u0005\u0005\u00141MA3\u0003S\ni\u0007\u0003\u0004y\u00037\u0002\r!\u001f\u0005\u0007\u0017\u0006m\u0003\u0019\u0001'\t\u000f\u0005\u001d\u00141\fa\u0001\u0007\u00069A/Z7q\t&\u0014\bbBA6\u00037\u0002\raQ\u0001\u000bi\u0016l\u0007OR8s[\u0006$\bbBA8\u00037\u0002\raQ\u0001\u000b]VdGn\u0015;sS:<\u0007bBA:\u0001\u0011\u0005\u0011QO\u0001\u000fg\u00064X\rV8SK\u0012\u001c\b.\u001b4u))\tY$a\u001e\u0002z\u0005m\u0014Q\u0011\u0005\u0007q\u0006E\u0004\u0019A=\t\r-\u000b\t\b1\u0001M\u0011!\ti(!\u001dA\u0002\u0005}\u0014\u0001C:bm\u0016lu\u000eZ3\u0011\u0007i\f\t)C\u0002\u0002\u0004~\u0013\u0001bU1wK6{G-\u001a\u0005\u0007I\u0006E\u0004\u0019A3")
public class RedshiftWriter {
    public final JDBCWrapper com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper;
    public final Function1<AWSCredentialsProvider, AmazonS3Client> com$databricks$spark$redshift$RedshiftWriter$$s3ClientFactory;
    private final Logger com$databricks$spark$redshift$RedshiftWriter$$log;

    public Logger com$databricks$spark$redshift$RedshiftWriter$$log() {
        return this.com$databricks$spark$redshift$RedshiftWriter$$log;
    }

    public String createTableSql(Dataset<Row> data, Parameters.MergedParameters params) {
        Option<String> option;
        block4: {
            Option<String> option2;
            block7: {
                String string;
                String distStyleDef;
                String schemaSql;
                block6: {
                    block5: {
                        String string2;
                        block3: {
                            block2: {
                                schemaSql = this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.schemaString(data.schema());
                                option = params.distStyle();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String style = (String)some.x();
                                string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DISTSTYLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{style}));
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string2 = "";
                        }
                        distStyleDef = string2;
                        option2 = params.distKey();
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String key = (String)some.x();
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DISTKEY (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}));
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    string = "";
                }
                String distKeyDef = string;
                String sortKeyDef = (String)params.sortKeySpec().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                TableName table2 = (TableName)params.table().get();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS ", " (", ") ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2, schemaSql, distStyleDef, distKeyDef, sortKeyDef}));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public String com$databricks$spark$redshift$RedshiftWriter$$copySql(SQLContext sqlContext, Parameters.MergedParameters params, AWSCredentialsProvider creds, String manifestUrl) {
        String string;
        block5: {
            String string2;
            String fixedUrl;
            String credsString;
            block3: {
                block4: {
                    block2: {
                        credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(params, creds.getCredentials());
                        fixedUrl = Utils$.MODULE$.fixS3Url(manifestUrl);
                        string = params.tempFormat();
                        if (!"AVRO".equals(string)) break block2;
                        string2 = "AVRO 'auto'";
                        break block3;
                    }
                    String string3 = string;
                    String string4 = "CSV";
                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block4;
                    String string5 = string;
                    String string6 = "CSV GZIP";
                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block5;
                }
                string2 = new StringBuilder().append((Object)string).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" NULL AS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.nullString()}))).toString();
            }
            String format = string2;
            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY ", " FROM '", "' CREDENTIALS '", "' FORMAT AS "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.table().get(), fixedUrl, credsString}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " manifest ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{format, params.extraCopyOptions()}))).toString();
        }
        throw new MatchError((Object)string);
    }

    public List<String> commentActions(Option<String> tableComment, StructType schema2) {
        return (List)((List)tableComment.toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String desc) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMMENT ON TABLE %s IS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc.replace("'", "''")}));
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return f.metadata().contains("description");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField f) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMMENT ON COLUMN %s.\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name().replace("\"", "\\\"")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" IS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.metadata().getString("description").replace("'", "''")}))).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), List$.MODULE$.canBuildFrom());
    }

    private void doRedshiftLoad(Connection conn, Dataset<Row> data, Parameters.MergedParameters params, AWSCredentialsProvider creds, Option<String> manifestUrl) {
        String createStatement = this.createTableSql(data, params);
        this.com$databricks$spark$redshift$RedshiftWriter$$log().info(createStatement);
        this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(conn.prepareStatement(createStatement));
        List preActions = (List)this.commentActions(params.description(), data.schema()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])params.preActions()), List$.MODULE$.canBuildFrom());
        preActions.foreach((Function1)new Serializable(this, conn, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$2;

            public final boolean apply(String action) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$2.table().get()})) : action;
                this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().info(new StringBuilder().append((Object)"Executing preAction: ").append((Object)actionSql).toString());
                return this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(actionSql));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.params$2 = params$2;
            }
        });
        manifestUrl.foreach((Function1)new Serializable(this, conn, data, params, creds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Dataset data$1;
            private final Parameters.MergedParameters params$2;
            private final AWSCredentialsProvider creds$1;

            public final boolean apply(String manifestUrl) {
                String copyStatement = this.$outer.com$databricks$spark$redshift$RedshiftWriter$$copySql(this.data$1.sqlContext(), this.params$2, this.creds$1, manifestUrl);
                this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().info(copyStatement);
                try {
                    return this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(copyStatement));
                }
                catch (SQLException sQLException) {
                    None$ none$;
                    this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().error("SQLException thrown while running COPY query; will attempt to retrieve more information by querying the STL_LOAD_ERRORS table", (Throwable)sQLException);
                    this.conn$1.rollback();
                    String errorLookupQuery = new StringOps(Predef$.MODULE$.augmentString("\n              | SELECT *\n              | FROM stl_load_errors\n              | WHERE query = pg_last_query_id()\n            ")).stripMargin();
                    try {
                        ResultSet results = this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeQueryInterruptibly(this.conn$1.prepareStatement(errorLookupQuery));
                        if (results.next()) {
                            int errCode = results.getInt("err_code");
                            String errReason = results.getString("err_reason").trim();
                            String columnLength = (String)Option$.MODULE$.apply((Object)results.getString("col_length")).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$1) {
                                    return x$1.trim();
                                }
                            }).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String x$2) {
                                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
                                }
                            }).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String n) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n}));
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            String exceptionMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                   |Error (code ", ") while loading data into Redshift: \"", "\"\n                   |Table name: ", "\n                   |Column name: ", "\n                   |Column type: ", "", "\n                   |Raw line: ", "\n                   |Raw field value: ", "\n                  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errCode), errReason, this.params$2.table().get(), results.getString("colname").trim(), results.getString("type").trim(), columnLength, results.getString("raw_line"), results.getString("raw_field_value")})))).stripMargin();
                            none$ = new Some((Object)new SQLException(exceptionMessage, sQLException));
                        } else {
                            none$ = None$.MODULE$;
                        }
                    }
                    catch (Throwable throwable) {
                        None$ none$2;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e2 = (Throwable)option.get();
                        this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().error("Error occurred while querying STL_LOAD_ERRORS", e2);
                        none$ = none$2 = None$.MODULE$;
                    }
                    None$ detailedException = none$;
                    throw (Throwable)detailedException.getOrElse((Function0)new Serializable(this, sQLException){
                        public static final long serialVersionUID = 0L;
                        private final SQLException e$1;

                        public final SQLException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.data$1 = data$1;
                this.params$2 = params$2;
                this.creds$1 = creds$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])params.postActions()).foreach((Function1)new Serializable(this, conn, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$2;

            public final boolean apply(String action) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$2.table().get()})) : action;
                this.$outer.com$databricks$spark$redshift$RedshiftWriter$$log().info(new StringBuilder().append((Object)"Executing postAction: ").append((Object)actionSql).toString());
                return this.$outer.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(actionSql));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.params$2 = params$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> unloadData(SQLContext sqlContext, Dataset<Row> data, String tempDir, String tempFormat, String nullString) {
        None$ none$;
        DataFrameWriter dataFrameWriter;
        Function1[] conversionFunctions = (Function1[])Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Function1<Object, Object> apply(StructField field) {
                Object object;
                DataType dataType = field.dataType();
                if (DateType$.MODULE$.equals(dataType)) {
                    SimpleDateFormat dateFormat = Conversions$.MODULE$.createRedshiftDateFormat();
                    object = new Serializable(this, dateFormat){
                        public static final long serialVersionUID = 0L;
                        private final SimpleDateFormat dateFormat$1;

                        public final String apply(Object v) {
                            return v == null ? null : this.dateFormat$1.format((Date)v);
                        }
                        {
                            this.dateFormat$1 = dateFormat$1;
                        }
                    };
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    SimpleDateFormat timestampFormat = Conversions$.MODULE$.createRedshiftTimestampFormat();
                    object = new Serializable(this, timestampFormat){
                        public static final long serialVersionUID = 0L;
                        private final SimpleDateFormat timestampFormat$1;

                        public final String apply(Object v) {
                            return v == null ? null : this.timestampFormat$1.format((Timestamp)v);
                        }
                        {
                            this.timestampFormat$1 = timestampFormat$1;
                        }
                    };
                } else {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object v) {
                            return v;
                        }
                    };
                }
                return object;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        Accumulable nonEmptyPartitions = sqlContext.sparkContext().accumulableCollection((Object)HashSet$.MODULE$.empty(), (Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(HashSet.class));
        RDD convertedRows = data.rdd().mapPartitions((Function1)new Serializable(this, conversionFunctions, nonEmptyPartitions){
            public static final long serialVersionUID = 0L;
            public final Function1[] conversionFunctions$1;
            private final Accumulable nonEmptyPartitions$1;

            public final Iterator<Row> apply(Iterator<Row> iter) {
                if (iter.hasNext()) {
                    this.nonEmptyPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)TaskContext$.MODULE$.get().partitionId()));
                }
                return iter.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Row apply(Row row) {
                        Object[] convertedValues = new Object[this.$outer.conversionFunctions$1.length];
                        for (int i = 0; i < this.$outer.conversionFunctions$1.length; ++i) {
                            convertedValues[i] = this.$outer.conversionFunctions$1[i].apply(row.apply(i));
                        }
                        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)convertedValues));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conversionFunctions$1 = conversionFunctions$1;
                this.nonEmptyPartitions$1 = nonEmptyPartitions$1;
            }
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schemaWithLowercaseColumnNames = StructType$.MODULE$.apply((Seq)data.schema().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField f) {
                return f.copy(f.name().toLowerCase(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (((TraversableOnce)schemaWithLowercaseColumnNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() != data.schema().size()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot save table to Redshift because two or more column names would be identical after conversion to lowercase: ").append((Object)((TraversableOnce)data.schema().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$4) {
                    return x$4.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        }
        StructType convertedSchema = StructType$.MODULE$.apply((Seq)schemaWithLowercaseColumnNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final StructField apply(StructField x0$1) {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    if (DateType$.MODULE$.equals(dataType)) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                if (structField == null) return structField;
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (!TimestampType$.MODULE$.equals(dataType)) return structField;
                return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        DataFrameWriter writer = sqlContext.createDataFrame(convertedRows, convertedSchema).write();
        String string = tempFormat;
        if ("AVRO".equals(string)) {
            dataFrameWriter = writer.format("com.databricks.spark.avro");
        } else if ("CSV".equals(string)) {
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString);
        } else {
            if (!"CSV GZIP".equals(string)) throw new MatchError((Object)string);
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("compression", "gzip");
        }
        dataFrameWriter.save(tempDir);
        if (((SetLike)nonEmptyPartitions.value()).isEmpty()) {
            none$ = None$.MODULE$;
            return none$;
        }
        FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
        Regex partitionIdRegex = new StringOps(Predef$.MODULE$.augmentString("^part-(?:r-)?(\\d+)[^\\d+].*$")).r();
        Set nonEmptyPartitionIds = ((TraversableOnce)nonEmptyPartitions.value()).toSet();
        Seq filesToLoad = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$5) {
                return x$5.getPath().getName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).collect((PartialFunction)new Serializable(this, partitionIdRegex, nonEmptyPartitionIds){
            public static final long serialVersionUID = 0L;
            private final Regex partitionIdRegex$1;
            private final Set nonEmptyPartitionIds$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String id;
                A1 A1 = x1;
                Option option = this.partitionIdRegex$1.unapplySeq(A1);
                Object object = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt())) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String id;
                String string = x1;
                Option option = this.partitionIdRegex$1.unapplySeq((CharSequence)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt()));
                return bl;
            }
            {
                this.partitionIdRegex$1 = partitionIdRegex$1;
                this.nonEmptyPartitionIds$1 = nonEmptyPartitionIds$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        String sanitizedTempDir = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString()))).stripSuffix("/");
        Seq manifestEntries = (Seq)filesToLoad.map((Function1)new Serializable(this, sanitizedTempDir){
            public static final long serialVersionUID = 0L;
            private final String sanitizedTempDir$1;

            public final String apply(String file) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"url\":\"", "/", "\", \"mandatory\":true}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sanitizedTempDir$1, file}));
            }
            {
                this.sanitizedTempDir$1 = sanitizedTempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String manifest = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"entries\": [", "]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manifestEntries.mkString(",\n")}));
        String manifestPath = new StringBuilder().append((Object)sanitizedTempDir).append((Object)"/manifest.json").toString();
        FSDataOutputStream fsDataOut = fs.create(new Path(manifestPath));
        try {
            fsDataOut.write(manifest.getBytes("utf-8"));
        }
        catch (Throwable throwable) {
            void var22_22;
            var22_22.close();
            throw throwable;
        }
        fsDataOut.close();
        none$ = new Some((Object)manifestPath);
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public void saveToRedshift(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
        }
        if (!params.useStagingTable()) {
            this.com$databricks$spark$redshift$RedshiftWriter$$log().warn("Setting useStagingTable=false is deprecated; instead, we recommend that you drop the target table yourself. For more details on this deprecation, seehttps://github.com/databricks/spark-redshift/pull/157");
        }
        AWSCredentialsProvider creds = AWSCredentialsUtils$.MODULE$.load(params, sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.getRegionForRedshiftCluster(params.jdbcUrl()).foreach((Function1)new Serializable(this, params, creds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            public final Parameters.MergedParameters params$1;
            private final AWSCredentialsProvider creds$2;

            public final void apply(String redshiftRegion) {
                Utils$.MODULE$.getRegionForS3Bucket(this.params$1.rootTempDir(), (AmazonS3Client)this.$outer.com$databricks$spark$redshift$RedshiftWriter$$s3ClientFactory.apply((Object)this.creds$2)).foreach((Function1)new Serializable(this, redshiftRegion){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$saveToRedshift$1 $outer;
                    private final String redshiftRegion$1;

                    public final void apply(String s3Region) {
                        boolean regionIsSetInExtraCopyOptions = this.$outer.params$1.extraCopyOptions().contains(s3Region) && this.$outer.params$1.extraCopyOptions().contains("region");
                        String string = this.redshiftRegion$1;
                        String string2 = s3Region;
                        if ((string == null ? string2 != null : !string.equals(string2)) && !regionIsSetInExtraCopyOptions) {
                            this.$outer.com$databricks$spark$redshift$RedshiftWriter$$anonfun$$$outer().com$databricks$spark$redshift$RedshiftWriter$$log().error(new StringBuilder().append((Object)"The Redshift cluster and S3 bucket are in different regions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " and ", ", respectively). In order to perform this cross-region "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.redshiftRegion$1, s3Region}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write, you must add \"region '", "'\" to the extracopyoptions parameter. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s3Region}))).append((Object)"For more details on cross-region usage, see the README.").toString());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.redshiftRegion$1 = redshiftRegion$1;
                    }
                });
            }

            public /* synthetic */ RedshiftWriter com$databricks$spark$redshift$RedshiftWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.params$1 = params$1;
                this.creds$2 = creds$2;
            }
        });
        String string = params.tempFormat();
        String string2 = "AVRO";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(String fieldName) {
                    boolean isValid;
                    char firstChar = fieldName.charAt(0);
                    boolean bl = isValid = (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(firstChar)) || firstChar == '_') && new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(fieldName)).tail())).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char c) {
                            return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_';
                        }
                    });
                    if (isValid) {
                        return;
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The field name '", "' is not supported when using the Avro tempformat. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName}))).append((Object)"Try using the CSV tempformat  instead. For more details, see ").append((Object)"https://github.com/databricks/spark-redshift/issues/84").toString());
                }
            });
        }
        Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params.rootTempDir(), (AmazonS3Client)this.com$databricks$spark$redshift$RedshiftWriter$$s3ClientFactory.apply((Object)creds));
        Option<String> manifestUrl = this.unloadData(sqlContext, data, params.createPerQueryTempDir(), params.tempFormat(), params.nullString());
        Connection conn = this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.getConnector(params.jdbcDriver(), params.jdbcUrl(), params.credentials());
        conn.setAutoCommit(false);
        try {
            TableName table2 = (TableName)params.table().get();
            SaveMode saveMode2 = saveMode;
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2}))));
                if (!params.useStagingTable()) {
                    conn.commit();
                }
            }
            this.com$databricks$spark$redshift$RedshiftWriter$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading new Redshift data to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2})));
            this.doRedshiftLoad(conn, data, params, creds, manifestUrl);
            conn.commit();
        }
        catch (Throwable throwable) {
            void var8_8;
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                try {
                    this.com$databricks$spark$redshift$RedshiftWriter$$log().error("Exception thrown during Redshift load; will roll back transaction", e);
                    var8_8.rollback();
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (option2.isEmpty()) {
                        throw throwable3;
                    }
                    Throwable e2 = (Throwable)option2.get();
                    this.com$databricks$spark$redshift$RedshiftWriter$$log().error("Exception while rolling back transaction", e2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw e;
            }
            catch (Throwable throwable5) {
                var8_8.close();
                throw throwable5;
            }
        }
        conn.close();
    }

    public RedshiftWriter(JDBCWrapper jdbcWrapper, Function1<AWSCredentialsProvider, AmazonS3Client> s3ClientFactory) {
        this.com$databricks$spark$redshift$RedshiftWriter$$jdbcWrapper = jdbcWrapper;
        this.com$databricks$spark$redshift$RedshiftWriter$$s3ClientFactory = s3ClientFactory;
        this.com$databricks$spark$redshift$RedshiftWriter$$log = LoggerFactory.getLogger(this.getClass());
    }
}

