/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.sql.perf;

import com.databricks.spark.sql.perf.BenchmarkResult;
import com.databricks.spark.sql.perf.BenchmarkResult$;
import com.databricks.spark.sql.perf.Benchmarkable;
import com.databricks.spark.sql.perf.BreakdownResult;
import com.databricks.spark.sql.perf.Failure;
import java.util.UUID;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageStatus;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public abstract class Benchmarkable$class {
    public static final BenchmarkResult benchmark(Benchmarkable $this, boolean includeBreakdown, String description, ArrayBuffer messages, long timeout) {
        $this.sparkContext().setJobDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Execution: ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name(), description})));
        $this.beforeBenchmark();
        BenchmarkResult result = Benchmarkable$class.runBenchmark($this, includeBreakdown, description, messages, timeout);
        Benchmarkable$class.afterBenchmark($this, $this.sqlContext().sparkContext());
        return result;
    }

    public static final String benchmark$default$2(Benchmarkable $this) {
        return "";
    }

    public static void beforeBenchmark(Benchmarkable $this) {
    }

    private static void afterBenchmark(Benchmarkable $this, SparkContext sc) {
        System.gc();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sc.getExecutorStorageStatus()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterable<BlockId> apply(StorageStatus status) {
                return (Iterable)status.blocks().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BlockId apply(Tuple2<BlockId, BlockStatus> x0$1) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                        if (tuple2 != null) {
                            BlockId bid;
                            BlockId blockId = bid = (BlockId)tuple2._1();
                            return blockId;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockId.class)))).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockId bid) {
                SparkEnv$.MODULE$.get().blockManager().master().removeBlock(bid);
            }
        });
    }

    private static BenchmarkResult runBenchmark(Benchmarkable $this, boolean includeBreakdown, String description, ArrayBuffer messages, long timeout) {
        String jobgroup = UUID.randomUUID().toString();
        ObjectRef result = new ObjectRef(null);
        Thread thread = new Thread($this, includeBreakdown, description, messages, jobgroup, result){
            private final /* synthetic */ Benchmarkable $outer;
            private final boolean includeBreakdown$1;
            private final String description$1;
            private final ArrayBuffer messages$1;
            private final String jobgroup$1;
            private final ObjectRef result$1;

            public void run() {
                this.$outer.sparkContext().setJobGroup(this.jobgroup$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"benchmark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name()})), true);
                this.result$1.elem = this.$outer.doBenchmark(this.includeBreakdown$1, this.description$1, (ArrayBuffer<String>)this.messages$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.includeBreakdown$1 = includeBreakdown$1;
                this.description$1 = description$1;
                this.messages$1 = messages$1;
                this.jobgroup$1 = jobgroup$1;
                this.result$1 = result$1;
                super("benchmark runner");
            }
        };
        thread.setDaemon(true);
        thread.start();
        thread.join(timeout);
        if (thread.isAlive()) {
            $this.sparkContext().cancelJobGroup(jobgroup);
            thread.interrupt();
            String x$1 = $this.name();
            String x$2 = $this.executionMode().toString();
            Some x$3 = new Some((Object)new Failure("Timeout", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timeout after ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(timeout / 1000L))}))));
            Map<String, String> x$4 = BenchmarkResult$.MODULE$.apply$default$3();
            Seq<String> x$5 = BenchmarkResult$.MODULE$.apply$default$4();
            Seq<String> x$6 = BenchmarkResult$.MODULE$.apply$default$5();
            Option<Object> x$7 = BenchmarkResult$.MODULE$.apply$default$6();
            Option<Object> x$8 = BenchmarkResult$.MODULE$.apply$default$7();
            Option<Object> x$9 = BenchmarkResult$.MODULE$.apply$default$8();
            Option<Object> x$10 = BenchmarkResult$.MODULE$.apply$default$9();
            Option<Object> x$11 = BenchmarkResult$.MODULE$.apply$default$10();
            Option<Object> x$12 = BenchmarkResult$.MODULE$.apply$default$11();
            Seq<BreakdownResult> x$13 = BenchmarkResult$.MODULE$.apply$default$12();
            Option<String> x$14 = BenchmarkResult$.MODULE$.apply$default$13();
            result.elem = new BenchmarkResult(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<Failure>)x$3);
        }
        return (BenchmarkResult)result.elem;
    }

    private static String runBenchmark$default$2(Benchmarkable $this) {
        return "";
    }

    public static String doBenchmark$default$2(Benchmarkable $this) {
        return "";
    }

    public static double measureTimeMs(Benchmarkable $this, Function0 f) {
        long startTime = System.nanoTime();
        f.apply();
        long endTime = System.nanoTime();
        return (double)(endTime - startTime) / (double)1000000;
    }

    public static void $init$(Benchmarkable $this) {
        $this.com$databricks$spark$sql$perf$Benchmarkable$_setter_$sqlContext_$eq(SQLContext$.MODULE$.getOrCreate(SparkContext$.MODULE$.getOrCreate()));
        $this.com$databricks$spark$sql$perf$Benchmarkable$_setter_$sparkContext_$eq($this.sqlContext().sparkContext());
    }
}

